/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.expression.ArithmeticExpr;
import ast.expression.Expression;
import ast.expression.IntConstant;
import ast.expression.IntegerOp;
import ast.expression.VariablePtrOf;
import ast.type.Type;
import ast.variable.ArrayAccess;
import ast.variable.VariableRef;
import knowledge.KnowTypes;

public class PointerExprMatcher {
    private Expression displacement;
    private VariableRef pointer;
    private KnowTypes types;

    public PointerExprMatcher(Expression expression, KnowTypes knowTypes) {
        this.types = knowTypes;
        this.parse(expression);
    }

    public Expression getDisplacement() {
        return this.displacement;
    }

    public VariableRef getPointer() {
        return this.pointer;
    }

    private void parse(Expression expression) {
        if (expression instanceof ArithmeticExpr) {
            this.parseArithmeticExpr((ArithmeticExpr)expression);
        } else if (expression instanceof VariableRef) {
            this.pointer = (VariableRef)expression;
            assert (this.types.getTypeOf(this.pointer) == Type.Pointer);
            this.displacement = new IntConstant(0L);
        } else if (expression instanceof VariablePtrOf) {
            if (!((expression = ((VariablePtrOf)expression).getVar()) instanceof ArrayAccess)) {
                throw new RuntimeException("Unknown pointer of: " + expression);
            }
            this.pointer = ((ArrayAccess)expression).getBase();
            this.displacement = ((ArrayAccess)expression).getIndex();
        } else {
            throw new RuntimeException("Unknown pointer access: " + expression);
        }
    }

    private void parseArithmeticExpr(ArithmeticExpr arithmeticExpr) {
        if (arithmeticExpr.getRight() instanceof ArithmeticExpr && arithmeticExpr.getLeft() instanceof ArithmeticExpr) {
            Expression expression;
            assert (arithmeticExpr.getOp() == IntegerOp.Add);
            ArithmeticExpr arithmeticExpr2 = (ArithmeticExpr)arithmeticExpr.getRight();
            ArithmeticExpr arithmeticExpr3 = (ArithmeticExpr)arithmeticExpr.getLeft();
            if (arithmeticExpr2.getOp() == IntegerOp.Mul) {
                assert (arithmeticExpr3.getOp() != IntegerOp.Mul);
                this.parse(arithmeticExpr3);
                expression = this.parseIndexVar(arithmeticExpr2);
            } else {
                assert (arithmeticExpr3.getOp() == IntegerOp.Mul);
                this.parse(arithmeticExpr2);
                expression = this.parseIndexVar(arithmeticExpr3);
            }
            assert (this.displacement != null);
            assert (this.types != null);
            this.displacement = new ArithmeticExpr(this.displacement, expression, IntegerOp.Add);
        } else if (arithmeticExpr.getRight() instanceof ArithmeticExpr) {
            assert (arithmeticExpr.getOp() == IntegerOp.Add);
            this.parse(arithmeticExpr.getLeft());
            Expression expression = this.parseIndexVar((ArithmeticExpr)arithmeticExpr.getRight());
            assert (this.displacement != null);
            assert (this.types != null);
            this.displacement = new ArithmeticExpr(this.displacement, expression, IntegerOp.Add);
        } else if (arithmeticExpr.getLeft() instanceof ArithmeticExpr) {
            assert (arithmeticExpr.getOp() == IntegerOp.Add);
            this.parse(arithmeticExpr.getRight());
            Expression expression = this.parseIndexVar((ArithmeticExpr)arithmeticExpr.getLeft());
            assert (this.displacement != null);
            assert (this.types != null);
            this.displacement = new ArithmeticExpr(this.displacement, expression, IntegerOp.Add);
        } else if (arithmeticExpr.getLeft() instanceof VariableRef) {
            assert (arithmeticExpr.getOp() == IntegerOp.Add);
            if (arithmeticExpr.getLeft() instanceof IntConstant) {
                this.pointer = (VariableRef)arithmeticExpr.getRight();
                this.displacement = arithmeticExpr.getLeft();
            } else if (arithmeticExpr.getRight() instanceof IntConstant) {
                this.pointer = (VariableRef)arithmeticExpr.getLeft();
                this.displacement = arithmeticExpr.getRight();
            } else if (this.types.getTypeOf(arithmeticExpr.getLeft()) == Type.Pointer) {
                this.pointer = (VariableRef)arithmeticExpr.getLeft();
                this.displacement = arithmeticExpr.getRight();
            } else {
                this.pointer = (VariableRef)arithmeticExpr.getRight();
                this.displacement = arithmeticExpr.getLeft();
            }
            assert (this.types.getTypeOf(this.pointer) == Type.Pointer);
            if (this.displacement instanceof IntConstant) {
                assert (arithmeticExpr.getRight() instanceof IntConstant);
                long l = ((IntConstant)this.displacement).getValue();
                assert (l % 4L == 0L);
                this.displacement = new IntConstant(l / 4L);
            } else {
                this.displacement = new ArithmeticExpr(this.displacement, new IntConstant(4L), IntegerOp.Div);
            }
        } else {
            throw new RuntimeException("Not yet implemented");
        }
    }

    private Expression parseIndexVar(ArithmeticExpr arithmeticExpr) {
        if (arithmeticExpr.getOp() == IntegerOp.Mul && arithmeticExpr.getRight() instanceof IntConstant && ((IntConstant)arithmeticExpr.getRight()).getValue() == 4L) {
            return arithmeticExpr.getLeft();
        }
        return new ArithmeticExpr(arithmeticExpr, new IntConstant(4L), IntegerOp.Div);
    }
}

