/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.BlockStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.NullStmt;
import ast.statement.RetStmt;
import ast.statement.Statement;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.traverser.AstStatementTraverser;
import ast.variable.Variable;

public class ReturnChecker
extends AstStatementTraverser<Void> {
    private boolean comeback = true;

    public static boolean comesBack(Statement statement) {
        ReturnChecker returnChecker = new ReturnChecker();
        returnChecker.visit(statement, null);
        return returnChecker.isComeback();
    }

    public final boolean isComeback() {
        return this.comeback;
    }

    @Override
    public Expression visit(Expression expression, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Variable visit(Variable variable, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Statement visit(Statement statement, Void void_) {
        if (this.comeback) {
            super.visit(statement, null);
        }
        return statement;
    }

    @Override
    protected Statement visitRetStmt(RetStmt retStmt, Void void_) {
        this.comeback = false;
        return retStmt;
    }

    @Override
    protected Statement visitIfStmt(IfStmt ifStmt, Void void_) {
        assert (this.comeback);
        this.visit(ifStmt.getThenBranch(), null);
        if (!this.comeback) {
            this.comeback = true;
            this.visit(ifStmt.getElseBranch(), null);
        }
        return ifStmt;
    }

    @Override
    protected Statement visitCaseStmt(CaseStmt caseStmt, Void void_) {
        assert (this.comeback);
        this.visit(caseStmt.getOther(), null);
        for (Statement statement : caseStmt.getOption().values()) {
            if (this.comeback) continue;
            this.comeback = true;
            this.visit(statement, null);
        }
        return caseStmt;
    }

    @Override
    protected Statement visitBlockStmt(BlockStmt blockStmt, Void void_) {
        return super.visitBlockStmt(blockStmt, null);
    }

    @Override
    protected Statement visitWhileStmt(WhileStmt whileStmt, Void void_) {
        return whileStmt;
    }

    @Override
    protected Statement visitDoWhileStmt(DoWhile doWhile, Void void_) {
        this.visit(doWhile.getBody(), null);
        return doWhile;
    }

    @Override
    protected Statement visitNullStmt(NullStmt nullStmt, Void void_) {
        return nullStmt;
    }

    @Override
    protected Statement visitVarDef(VarDef varDef, Void void_) {
        return varDef;
    }

    @Override
    protected Statement visitCallStmt(CallStmt callStmt, Void void_) {
        return callStmt;
    }

    @Override
    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, Void void_) {
        return assignmentStmt;
    }
}

