/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.Statement;
import ast.statement.WhileStmt;
import ast.traverser.AstStatementTraverser;
import ast.traverser.ExprLiveRangeShortener;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class StmtLiveRangeShortener
extends AstStatementTraverser<Map<Variable, Variable>> {
    private ExprLiveRangeShortener exprvisitor = new ExprLiveRangeShortener();

    StmtLiveRangeShortener() {
    }

    @Override
    public Expression visit(Expression expression, Map<Variable, Variable> map) {
        return this.exprvisitor.visit(expression, map);
    }

    @Override
    public Variable visit(Variable variable, Map<Variable, Variable> map) {
        return variable;
    }

    @Override
    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, Map<Variable, Variable> map) {
        assignmentStmt.setSource(this.visit(assignmentStmt.getSource(), map));
        if (assignmentStmt.getDestination() instanceof VariableRefLinked) {
            VariableRefLinked variableRefLinked;
            VariableRefLinked variableRefLinked2 = (VariableRefLinked)assignmentStmt.getDestination();
            map.remove(variableRefLinked2.getReference());
            if (assignmentStmt.getSource() instanceof VariableRefLinked && !(variableRefLinked = (VariableRefLinked)assignmentStmt.getSource()).getReference().equals(variableRefLinked2.getReference())) {
                map.put(variableRefLinked.getReference(), variableRefLinked2.getReference());
            }
        }
        return assignmentStmt;
    }

    @Override
    protected Statement visitIfStmt(IfStmt ifStmt, Map<Variable, Variable> map) {
        ifStmt.setCondition(this.visit(ifStmt.getCondition(), map));
        HashMap<Variable, Variable> hashMap = new HashMap<Variable, Variable>(map);
        HashMap<Variable, Variable> hashMap2 = new HashMap<Variable, Variable>(map);
        ifStmt.setThenBranch(this.visit(ifStmt.getThenBranch(), hashMap));
        ifStmt.setElseBranch(this.visit(ifStmt.getElseBranch(), hashMap2));
        this.merge(map, hashMap, hashMap2);
        return ifStmt;
    }

    private void merge(Map<Variable, Variable> map, Map<Variable, Variable> map2, Map<Variable, Variable> map3) {
        map.clear();
        HashSet<Variable> hashSet = new HashSet<Variable>(map2.keySet());
        hashSet.retainAll(map3.keySet());
        for (Variable variable : hashSet) {
            if (!map2.get(variable).equals(map3.get(variable))) continue;
            map.put(variable, map2.get(variable));
        }
    }

    @Override
    protected Statement visitWhileStmt(WhileStmt whileStmt, Map<Variable, Variable> map) {
        HashMap<Variable, Variable> hashMap = new HashMap<Variable, Variable>();
        whileStmt.setBody(this.visit(whileStmt.getBody(), hashMap));
        this.merge(map, hashMap, new HashMap<Variable, Variable>(map));
        whileStmt.setCondition(this.visit(whileStmt.getCondition(), map));
        return whileStmt;
    }

    @Override
    protected Statement visitDoWhileStmt(DoWhile doWhile, Map<Variable, Variable> map) {
        map.clear();
        doWhile.setBody(this.visit(doWhile.getBody(), map));
        doWhile.setCondition(this.visit(doWhile.getCondition(), map));
        return doWhile;
    }

    @Override
    protected Statement visitCaseStmt(CaseStmt caseStmt, Map<Variable, Variable> map) {
        caseStmt.setCondition(this.visit(caseStmt.getCondition(), map));
        this.visit(caseStmt.getOther(), new HashMap<Variable, Variable>(map));
        for (Statement statement : caseStmt.getOption().values()) {
            this.visit(statement, new HashMap<Variable, Variable>(map));
        }
        map.clear();
        return caseStmt;
    }
}

