/*
 * Decompiled with CFR 0.152.
 */
package ast.traverser;

import ast.PrgFunc;
import ast.Program;
import ast.statement.BlockStmt;
import ast.statement.VarDef;
import ast.traverser.AstTraverser;
import ast.traverser.NopAstStatementTraverser;
import ast.traverser.VariableAccessCollector;
import ast.type.Type;
import ast.variable.Variable;
import java.util.ArrayList;
import java.util.Collections;

public class VariableInserter {
    public static void process(Program program) {
        for (PrgFunc prgFunc : program.getFunction()) {
            VariableInserter.process(prgFunc);
        }
    }

    public static void process(PrgFunc prgFunc) {
        VariableAccessCollector variableAccessCollector = new VariableAccessCollector();
        AstTraverser<Void> astTraverser = new AstTraverser<Void>(new NopAstStatementTraverser<Void>(variableAccessCollector));
        astTraverser.visit(prgFunc, null);
        ArrayList<String> arrayList = new ArrayList<String>(variableAccessCollector.getUnlinked());
        Collections.sort(arrayList);
        for (Variable object : variableAccessCollector.getDefined()) {
            arrayList.remove(object.getName());
        }
        BlockStmt blockStmt = new BlockStmt();
        for (String string : arrayList) {
            blockStmt.addCode(new VarDef(new Variable(string, Type.Generic)));
        }
        blockStmt.addCode(prgFunc.getBody());
        prgFunc.setBody(blockStmt);
    }
}

