/*
 * Decompiled with CFR 0.152.
 */
package cfg;

import ast.Program;
import ast.type.Type;
import cfg.function.FuncProtParam;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.library.LibraryFunctions;
import cfg.function.system.SystemFunctions;
import elfreader.ElfReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import knowledge.KnowledgeBase;

public class Application {
    private File file;
    private List<PrgFunction> funcs = null;
    private PrgFunction main = null;
    private LibraryFunctions dynlib = Application.createLinuxLibs();
    private SystemFunctions asmfunc;
    private long mainAddr;
    private KnowledgeBase kb;
    private ElfReader elfReader;

    public Application(File file, SystemFunctions systemFunctions) {
        this.asmfunc = systemFunctions;
        this.file = file;
        this.kb = new KnowledgeBase(this, new Program("UserPrg"));
    }

    public void setFunctions(List<PrgFunction> list, PrgFunction prgFunction) {
        assert (list.contains(prgFunction));
        this.main = prgFunction;
        this.funcs = list;
    }

    public List<PrgFunction> getFunctions() {
        return this.funcs;
    }

    public Program getPrg() {
        return this.kb.getPrg();
    }

    public PrgFunction getMain() {
        return this.main;
    }

    public LibraryFunctions getDynlib() {
        return this.dynlib;
    }

    public SystemFunctions getAsmfunc() {
        return this.asmfunc;
    }

    public final File getFile() {
        return this.file;
    }

    public final long getMainAddr() {
        return this.mainAddr;
    }

    public final void setMainAddr(long l) {
        this.mainAddr = l;
    }

    public final KnowledgeBase getKb() {
        return this.kb;
    }

    public final void setKb(KnowledgeBase knowledgeBase) {
        this.kb = knowledgeBase;
    }

    public final ElfReader getElfReader() {
        return this.elfReader;
    }

    public final void setElfReader(ElfReader elfReader) {
        this.elfReader = elfReader;
    }

    private static LibraryFunctions createLinuxLibs() {
        LibraryFunctions libraryFunctions = new LibraryFunctions();
        Application.addFunction(libraryFunctions, "exit", Application.ap("status", Type.Integer, Application.ep()), false, Type.Void);
        Application.addFunction(libraryFunctions, "abort", Application.ep(), false, Type.Void);
        Application.addFunction(libraryFunctions, "error", Application.ap("status", Type.Integer, Application.ap("errnum", Type.Integer, Application.ap("format", Type.String, Application.ep()))), true, Type.Void);
        Application.addFunction(libraryFunctions, "__cxa_atexit", Application.ap("func", Type.Pointer, Application.ap("p", Type.Pointer, Application.ap("d", Type.Pointer, Application.ep()))), true, Type.Integer);
        Application.addFunction(libraryFunctions, "perror", Application.ap("s", Type.Integer, Application.ep()), true, Type.Void);
        Application.addFunction(libraryFunctions, "__isoc99_fscanf", Application.ap("stream", Type.Pointer, Application.ap("format", Type.String, Application.ep())), true, Type.Integer);
        Application.addFunction(libraryFunctions, "__isoc99_scanf", Application.ap("format", Type.String, Application.ep()), true, Type.Integer);
        Application.addFunction(libraryFunctions, "fwrite", Application.ap("ptr", Type.Pointer, Application.ap("size", Type.Integer, Application.ap("nmemb", Type.Integer, Application.ap("stream", Type.Pointer, Application.ep())))), true, Type.Integer);
        Application.addFunction(libraryFunctions, "printf", Application.ap("format", Type.String, Application.ep()), true, Type.Integer);
        Application.addFunction(libraryFunctions, "fread", Application.ap("ptr", Type.Pointer, Application.ap("size", Type.Integer, Application.ap("nmemb", Type.Integer, Application.ap("stream", Type.Pointer, Application.ep())))), true, Type.Integer);
        Application.addFunction(libraryFunctions, "puts", Application.ap("s", Type.Pointer, Application.ep()), true, Type.Integer);
        Application.addFunction(libraryFunctions, "putchar", Application.ap("c", Type.Integer, Application.ep()), true, Type.Integer);
        Application.addFunction(libraryFunctions, "malloc", Application.ap("size", Type.Integer, Application.ep()), true, Type.Pointer);
        Application.addFunction(libraryFunctions, "free", Application.ap("ptr", Type.Pointer, Application.ep()), true, Type.Void);
        return libraryFunctions;
    }

    private static ArrayList<FuncProtParam> ep() {
        return new ArrayList<FuncProtParam>();
    }

    private static ArrayList<FuncProtParam> ap(String string, Type type, ArrayList<FuncProtParam> arrayList) {
        arrayList.add(0, new FuncProtParam(string, type));
        return arrayList;
    }

    private static void addFunction(LibraryFunctions libraryFunctions, String string, ArrayList<FuncProtParam> arrayList, boolean bl, Type type) {
        libraryFunctions.addFunction(new LibFunction(string, arrayList, bl, type));
    }
}

