/*
 * Decompiled with CFR 0.152.
 */
package cfg;

import cfg.Flags;
import cfg.IntConstant;
import cfg.expression.CompareExpr;
import cfg.expression.CompareOp;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRefUnlinked;
import disassembler.diStorm3.OpcodeEnum;

public enum Condition {
    Overflow,
    NoOverflow,
    Below,
    AboveOrEqual,
    EqualZero,
    NotEqualNotZero,
    BelowOrEqual,
    Above,
    Sign,
    NoSign,
    Parity,
    NoParity,
    LessThan,
    GreaterThanOrEqual,
    LessThanOrEqual,
    GreaterThan;


    public static Condition parse(OpcodeEnum opcodeEnum) {
        switch (opcodeEnum) {
            case JO: 
            case CMOVO: 
            case SETO: {
                return Overflow;
            }
            case JNO: 
            case CMOVNO: 
            case SETNO: {
                return NoOverflow;
            }
            case JB: 
            case CMOVB: 
            case SETB: {
                return Below;
            }
            case JAE: 
            case CMOVAE: 
            case SETAE: {
                return AboveOrEqual;
            }
            case JZ: 
            case CMOVZ: 
            case SETZ: {
                return EqualZero;
            }
            case JNZ: 
            case CMOVNZ: 
            case SETNZ: {
                return NotEqualNotZero;
            }
            case JBE: 
            case CMOVBE: 
            case SETBE: {
                return BelowOrEqual;
            }
            case JA: 
            case CMOVA: 
            case SETA: {
                return Above;
            }
            case JS: 
            case CMOVS: 
            case SETS: {
                return Sign;
            }
            case JNS: 
            case CMOVNS: 
            case SETNS: {
                return NoSign;
            }
            case JP: 
            case CMOVP: 
            case SETP: {
                return Parity;
            }
            case JNP: 
            case CMOVNP: 
            case SETNP: {
                return NoParity;
            }
            case JL: 
            case CMOVL: 
            case SETL: {
                return LessThan;
            }
            case JGE: 
            case CMOVGE: 
            case SETGE: {
                return GreaterThanOrEqual;
            }
            case JLE: 
            case CMOVLE: 
            case SETLE: {
                return LessThanOrEqual;
            }
            case JG: 
            case CMOVG: 
            case SETG: {
                return GreaterThan;
            }
        }
        return null;
    }

    public static Expression buildExpr(Condition condition) {
        VariableRefUnlinked variableRefUnlinked = new VariableRefUnlinked(Flags.Overflow);
        VariableRefUnlinked variableRefUnlinked2 = new VariableRefUnlinked(Flags.Carry);
        VariableRefUnlinked variableRefUnlinked3 = new VariableRefUnlinked(Flags.Zero);
        VariableRefUnlinked variableRefUnlinked4 = new VariableRefUnlinked(Flags.Sign);
        VariableRefUnlinked variableRefUnlinked5 = new VariableRefUnlinked(Flags.Parity);
        IntConstant intConstant = new IntConstant(0L);
        IntConstant intConstant2 = new IntConstant(1L);
        switch (condition) {
            case Overflow: {
                return new CompareExpr(variableRefUnlinked, intConstant2, CompareOp.EQUAL);
            }
            case NoOverflow: {
                return new CompareExpr(variableRefUnlinked, intConstant, CompareOp.EQUAL);
            }
            case Below: {
                return new CompareExpr(variableRefUnlinked2, intConstant2, CompareOp.EQUAL);
            }
            case AboveOrEqual: {
                return new CompareExpr(variableRefUnlinked2, intConstant, CompareOp.EQUAL);
            }
            case EqualZero: {
                return new CompareExpr(variableRefUnlinked3, intConstant2, CompareOp.EQUAL);
            }
            case NotEqualNotZero: {
                return new CompareExpr(variableRefUnlinked3, intConstant, CompareOp.EQUAL);
            }
            case BelowOrEqual: {
                return new IntegerExpr(new CompareExpr(variableRefUnlinked2, intConstant2, CompareOp.EQUAL), new CompareExpr(variableRefUnlinked3, intConstant2, CompareOp.EQUAL), IntegerOp.Or);
            }
            case Above: {
                return new IntegerExpr(new CompareExpr(variableRefUnlinked2, intConstant, CompareOp.EQUAL), new CompareExpr(variableRefUnlinked3, intConstant, CompareOp.EQUAL), IntegerOp.And);
            }
            case Sign: {
                return new CompareExpr(variableRefUnlinked4, intConstant2, CompareOp.EQUAL);
            }
            case NoSign: {
                return new CompareExpr(variableRefUnlinked4, intConstant, CompareOp.EQUAL);
            }
            case Parity: {
                return new CompareExpr(variableRefUnlinked5, intConstant2, CompareOp.EQUAL);
            }
            case NoParity: {
                return new CompareExpr(variableRefUnlinked5, intConstant, CompareOp.EQUAL);
            }
            case LessThan: {
                return new CompareExpr(variableRefUnlinked4, variableRefUnlinked, CompareOp.NOT_EQUAL);
            }
            case GreaterThanOrEqual: {
                return new CompareExpr(variableRefUnlinked4, variableRefUnlinked, CompareOp.EQUAL);
            }
            case LessThanOrEqual: {
                return new IntegerExpr(new CompareExpr(variableRefUnlinked3, intConstant2, CompareOp.EQUAL), new CompareExpr(variableRefUnlinked4, variableRefUnlinked, CompareOp.NOT_EQUAL), IntegerOp.Or);
            }
            case GreaterThan: {
                return new IntegerExpr(new CompareExpr(variableRefUnlinked3, intConstant, CompareOp.EQUAL), new CompareExpr(variableRefUnlinked4, variableRefUnlinked, CompareOp.EQUAL), IntegerOp.And);
            }
        }
        throw new RuntimeException("Unknown condition: " + (Object)((Object)condition));
    }
}

