/*
 * Decompiled with CFR 0.152.
 */
package cfg;

import cfg.BooleanConstant;
import cfg.IntConstant;
import cfg.IrElement;
import cfg.Memory;
import cfg.StringConstant;
import cfg.basicblock.BasicBlock;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.CompareExpr;
import cfg.expression.Expression;
import cfg.expression.IfExpr;
import cfg.expression.IntegerExpr;
import cfg.expression.UnaryExpression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;
import cfg.statement.PhiStmt;
import cfg.statement.RetStmt;
import cfg.statement.Statement;
import cfg.variable.Array;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.SsaVariable;
import cfg.variable.StackVariable;
import cfg.variable.VariableAddrCalc;
import cfg.variable.VariableName;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IrReplaceExprTraverser<P> {
    public void visit(IrElement irElement, P p) {
        if (irElement instanceof Statement) {
            this.visitStatement((Statement)irElement, p);
        } else if (irElement instanceof Expression) {
            this.visitExpression((Expression)irElement, p);
        } else if (irElement instanceof BasicBlock) {
            this.visitBasicBlock((BasicBlock)irElement, p);
        } else if (irElement instanceof Function) {
            this.visitFunction((Function)irElement, p);
        } else if (irElement instanceof SsaVariable) {
            this.visitSsaVariable((SsaVariable)irElement, p);
        } else if (irElement instanceof Array) {
            this.visitArray((Array)irElement, p);
        } else {
            throw new RuntimeException("Unhandled class: " + irElement.getClass());
        }
    }

    public void visitCollection(Collection<? extends IrElement> collection, P p) {
        for (IrElement irElement : collection) {
            this.visit(irElement, p);
        }
    }

    protected void visitArray(Array array, P p) {
    }

    protected void visitSsaVariable(SsaVariable ssaVariable, P p) {
    }

    protected void visitFunction(Function function, P p) {
        if (function instanceof LibFunction) {
            this.visitLibFunction((LibFunction)function, p);
        } else if (function instanceof PrgFunction) {
            this.visitPrgFunction((PrgFunction)function, p);
        } else {
            throw new RuntimeException("Unhandled class: " + function.getClass());
        }
    }

    protected void visitPrgFunction(PrgFunction prgFunction, P p) {
        this.visitCollection(prgFunction.getArrays(), p);
        this.visitCollection(prgFunction.getGraph().vertexSet(), p);
    }

    protected void visitLibFunction(LibFunction libFunction, P p) {
    }

    protected void visitBasicBlock(BasicBlock basicBlock, P p) {
        this.visitCollection(basicBlock.getCode(), p);
    }

    protected void visitExprSet(Set<Expression> set, P p) {
        HashSet<Expression> hashSet = new HashSet<Expression>(set);
        set.clear();
        for (Expression expression : hashSet) {
            set.add(this.visitExpression(expression, p));
        }
    }

    protected void visitExprList(List<Expression> list, P p) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.visitExpression(list.get(i), p));
        }
    }

    protected Expression visitExpression(Expression expression, P p) {
        if (expression instanceof CompareExpr) {
            return this.visitCompareExpr((CompareExpr)expression, p);
        }
        if (expression instanceof IntegerExpr) {
            return this.visitIntegerExpr((IntegerExpr)expression, p);
        }
        if (expression instanceof IfExpr) {
            return this.visitIfExpr((IfExpr)expression, p);
        }
        if (expression instanceof Memory) {
            return this.visitMemory((Memory)expression, p);
        }
        if (expression instanceof VariableRefUnlinked) {
            return this.visitVariableRefUnlinked((VariableRefUnlinked)expression, p);
        }
        if (expression instanceof VariableRefLinked) {
            return this.visitVariableRefLinked((VariableRefLinked)expression, p);
        }
        if (expression instanceof VariableKilled) {
            return this.visitVariableKilled((VariableKilled)expression, p);
        }
        if (expression instanceof IntConstant) {
            return this.visitConstant((IntConstant)expression, p);
        }
        if (expression instanceof StringConstant) {
            return this.visitStringConstant((StringConstant)expression, p);
        }
        if (expression instanceof BooleanConstant) {
            return this.visitBooleanConstant((BooleanConstant)expression, p);
        }
        if (expression instanceof UnaryExpression) {
            return this.visitUnaryExpression((UnaryExpression)expression, p);
        }
        if (expression instanceof CallExprLinked) {
            return this.visitCallExprLinked((CallExprLinked)expression, p);
        }
        if (expression instanceof CallExprUnlinked) {
            return this.visitCallExprUnlinked((CallExprUnlinked)expression, p);
        }
        if (expression instanceof CallExprPointer) {
            return this.visitCallExprPointer((CallExprPointer)expression, p);
        }
        throw new RuntimeException("Unhandled class: " + expression.getClass());
    }

    protected Expression visitCallExprLinked(CallExprLinked callExprLinked, P p) {
        this.visitExprList(callExprLinked.getParam(), p);
        return callExprLinked;
    }

    protected Expression visitCallExprUnlinked(CallExprUnlinked callExprUnlinked, P p) {
        this.visitExprList(callExprUnlinked.getParam(), p);
        return callExprUnlinked;
    }

    protected Expression visitCallExprPointer(CallExprPointer callExprPointer, P p) {
        callExprPointer.setExpr(this.visitExpression(callExprPointer.getExpr(), p));
        this.visitExprList(callExprPointer.getParam(), p);
        return callExprPointer;
    }

    protected Expression visitUnaryExpression(UnaryExpression unaryExpression, P p) {
        unaryExpression.setExpr(this.visitExpression(unaryExpression.getExpr(), p));
        return unaryExpression;
    }

    protected Expression visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, P p) {
        return variableRefUnlinked;
    }

    protected Expression visitVariableRefLinked(VariableRefLinked variableRefLinked, P p) {
        return variableRefLinked;
    }

    protected Expression visitVariableKilled(VariableKilled variableKilled, P p) {
        return variableKilled;
    }

    protected Expression visitMemory(Memory memory, P p) {
        if (memory instanceof GlobalVariable) {
            return this.visitGlobalVariable((GlobalVariable)memory, p);
        }
        if (memory instanceof ArrayAccess) {
            return this.visitVariableArray((ArrayAccess)memory, p);
        }
        if (memory instanceof StackVariable) {
            return this.visitStackVariable((StackVariable)memory, p);
        }
        if (memory instanceof VariableAddrCalc) {
            return this.visitVariableAddrCalc((VariableAddrCalc)memory, p);
        }
        throw new RuntimeException("Unhandled class: " + memory.getClass());
    }

    protected BooleanConstant visitBooleanConstant(BooleanConstant booleanConstant, P p) {
        return booleanConstant;
    }

    protected Expression visitStringConstant(StringConstant stringConstant, P p) {
        return stringConstant;
    }

    protected IntConstant visitConstant(IntConstant intConstant, P p) {
        return intConstant;
    }

    protected Expression visitVariableAddrCalc(VariableAddrCalc variableAddrCalc, P p) {
        if (variableAddrCalc instanceof VariablePtrDeref) {
            return this.visitVariablePtrDeref((VariablePtrDeref)variableAddrCalc, p);
        }
        if (variableAddrCalc instanceof VariablePtrOf) {
            return this.visitVariablePtrOf((VariablePtrOf)variableAddrCalc, p);
        }
        throw new RuntimeException("Unhandled class: " + variableAddrCalc.getClass());
    }

    protected Expression visitVariablePtrOf(VariablePtrOf variablePtrOf, P p) {
        variablePtrOf.setExpression(this.visitExpression(variablePtrOf.getExpression(), p));
        return variablePtrOf;
    }

    protected Expression visitVariableArray(ArrayAccess arrayAccess, P p) {
        arrayAccess.setIndex(this.visitExpression(arrayAccess.getIndex(), p));
        return arrayAccess;
    }

    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, P p) {
        variablePtrDeref.setExpression(this.visitExpression(variablePtrDeref.getExpression(), p));
        return variablePtrDeref;
    }

    protected StackVariable visitStackVariable(StackVariable stackVariable, P p) {
        return stackVariable;
    }

    protected GlobalVariable visitGlobalVariable(GlobalVariable globalVariable, P p) {
        return globalVariable;
    }

    protected Expression visitIfExpr(IfExpr ifExpr, P p) {
        ifExpr.setCondition(this.visitExpression(ifExpr.getCondition(), p));
        ifExpr.setLeft(this.visitExpression(ifExpr.getLeft(), p));
        ifExpr.setRight(this.visitExpression(ifExpr.getRight(), p));
        return ifExpr;
    }

    protected Expression visitIntegerExpr(IntegerExpr integerExpr, P p) {
        integerExpr.setLeft(this.visitExpression(integerExpr.getLeft(), p));
        integerExpr.setRight(this.visitExpression(integerExpr.getRight(), p));
        return integerExpr;
    }

    protected Expression visitCompareExpr(CompareExpr compareExpr, P p) {
        compareExpr.setLeft(this.visitExpression(compareExpr.getLeft(), p));
        compareExpr.setRight(this.visitExpression(compareExpr.getRight(), p));
        return compareExpr;
    }

    protected void visitStatement(Statement statement, P p) {
        if (statement.isDeleted()) {
            return;
        }
        if (statement instanceof JumpStmt) {
            this.visitJumpStmt((JumpStmt)statement, p);
        } else if (statement instanceof PhiStmt) {
            this.visitPhiStmt((PhiStmt)statement, p);
        } else if (statement instanceof AssignmentStmt) {
            this.visitAssignmentStmt((AssignmentStmt)statement, p);
        } else if (statement instanceof NopStmt) {
            this.visitNopStmt((NopStmt)statement, p);
        } else if (statement instanceof RetStmt) {
            this.visitRetStmt((RetStmt)statement, p);
        } else {
            throw new RuntimeException("Unhandled class: " + statement.getClass());
        }
    }

    protected void visitPhiStmt(PhiStmt phiStmt, P p) {
        this.visit(phiStmt.getVarname(), p);
        for (Long l : phiStmt.getOption().keySet()) {
            phiStmt.getOption().put(l, this.visitExpression(phiStmt.getOption().get(l), p));
        }
    }

    protected void visitRetStmt(RetStmt retStmt, P p) {
        Map<VariableName, Expression> map = retStmt.getRetval();
        for (VariableName variableName : map.keySet()) {
            map.put(variableName, this.visitExpression(map.get(variableName), p));
        }
    }

    protected void visitJumpStmt(JumpStmt jumpStmt, P p) {
        jumpStmt.setExpression(this.visitExpression(jumpStmt.getExpression(), p));
    }

    protected void visitNopStmt(NopStmt nopStmt, P p) {
    }

    protected void visitAssignmentStmt(AssignmentStmt assignmentStmt, P p) {
        assignmentStmt.setSource(this.visitExpression(assignmentStmt.getSource(), p));
        this.visitCollection(assignmentStmt.getDestination(), p);
    }
}

