/*
 * Decompiled with CFR 0.152.
 */
package cfg;

import cfg.BooleanConstant;
import cfg.IntConstant;
import cfg.IrElement;
import cfg.Memory;
import cfg.StringConstant;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.CompareExpr;
import cfg.expression.Expression;
import cfg.expression.IfExpr;
import cfg.expression.IntegerExpr;
import cfg.expression.UnaryExpression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.SysFunction;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;
import cfg.statement.PhiStmt;
import cfg.statement.RetStmt;
import cfg.statement.Statement;
import cfg.variable.Array;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.SsaVariable;
import cfg.variable.StackVariable;
import cfg.variable.VariableAddrCalc;
import cfg.variable.VariableName;
import cfg.variable.VariablePtrDeref;
import cfg.variable.VariablePtrOf;
import java.util.Collection;
import java.util.Map;

public class IrTraverser<R, P> {
    public R visit(Object object, P p) {
        if (object instanceof Statement) {
            return this.visitStatement((Statement)object, p);
        }
        if (object instanceof Expression) {
            return this.visitExpression((Expression)object, p);
        }
        if (object instanceof BasicBlock) {
            return this.visitBasicBlock((BasicBlock)object, p);
        }
        if (object instanceof Function) {
            return this.visitFunction((Function)object, p);
        }
        if (object instanceof SsaVariable) {
            return this.visitSsaVariable((SsaVariable)object, p);
        }
        if (object instanceof Array) {
            return this.visitArray((Array)object, p);
        }
        if (object instanceof Collection) {
            return this.visitCollection((Collection)object, p);
        }
        throw new RuntimeException("Unhandled class: " + object.getClass());
    }

    protected R visitBbEdge(BbEdge bbEdge, P p) {
        return null;
    }

    protected R visitSsaVariable(SsaVariable ssaVariable, P p) {
        return null;
    }

    protected R visitArray(Array array, P p) {
        return null;
    }

    protected R visitFunction(Function function, P p) {
        if (function instanceof LibFunction) {
            return this.visitLibFunction((LibFunction)function, p);
        }
        if (function instanceof PrgFunction) {
            return this.visitPrgFunction((PrgFunction)function, p);
        }
        if (function instanceof SysFunction) {
            return this.visitSysFunction((SysFunction)function, p);
        }
        throw new RuntimeException("Unhandled class: " + function.getClass());
    }

    protected R visitSysFunction(SysFunction sysFunction, P p) {
        return null;
    }

    protected R visitPrgFunction(PrgFunction prgFunction, P p) {
        this.visit(prgFunction.getArrays(), p);
        this.visit(prgFunction.getGraph().vertexSet(), p);
        return null;
    }

    protected R visitLibFunction(LibFunction libFunction, P p) {
        return null;
    }

    protected R visitBasicBlock(BasicBlock basicBlock, P p) {
        this.visit(basicBlock.getCode(), p);
        return null;
    }

    protected R visitCollection(Collection<IrElement> collection, P p) {
        for (IrElement irElement : collection) {
            this.visit(irElement, p);
        }
        return null;
    }

    protected R visitExpression(Expression expression, P p) {
        if (expression instanceof CompareExpr) {
            return this.visitCompareExpr((CompareExpr)expression, p);
        }
        if (expression instanceof IntegerExpr) {
            return this.visitIntegerExpr((IntegerExpr)expression, p);
        }
        if (expression instanceof IfExpr) {
            return this.visitIfExpr((IfExpr)expression, p);
        }
        if (expression instanceof Memory) {
            return this.visitMemory((Memory)expression, p);
        }
        if (expression instanceof VariableRefUnlinked) {
            return this.visitVariableRefUnlinked((VariableRefUnlinked)expression, p);
        }
        if (expression instanceof VariableRefLinked) {
            return this.visitVariableRefLinked((VariableRefLinked)expression, p);
        }
        if (expression instanceof VariableKilled) {
            return this.visitVariableKilled((VariableKilled)expression, p);
        }
        if (expression instanceof IntConstant) {
            return this.visitConstant((IntConstant)expression, p);
        }
        if (expression instanceof StringConstant) {
            return this.visitStringConstant((StringConstant)expression, p);
        }
        if (expression instanceof BooleanConstant) {
            return this.visitBooleanConstant((BooleanConstant)expression, p);
        }
        if (expression instanceof UnaryExpression) {
            return this.visitUnaryExpression((UnaryExpression)expression, p);
        }
        if (expression instanceof CallExprLinked) {
            return this.visitCallExprLinked((CallExprLinked)expression, p);
        }
        if (expression instanceof CallExprUnlinked) {
            return this.visitCallExprUnlinked((CallExprUnlinked)expression, p);
        }
        if (expression instanceof CallExprPointer) {
            return this.visitCallExprPointer((CallExprPointer)expression, p);
        }
        throw new RuntimeException("Unhandled class: " + expression.getClass());
    }

    protected R visitCallExprLinked(CallExprLinked callExprLinked, P p) {
        this.visit(callExprLinked.getParam(), p);
        return null;
    }

    protected R visitCallExprUnlinked(CallExprUnlinked callExprUnlinked, P p) {
        this.visit(callExprUnlinked.getParam(), p);
        return null;
    }

    protected R visitCallExprPointer(CallExprPointer callExprPointer, P p) {
        this.visit(callExprPointer.getExpr(), p);
        this.visit(callExprPointer.getParam(), p);
        return null;
    }

    protected R visitUnaryExpression(UnaryExpression unaryExpression, P p) {
        this.visit(unaryExpression.getExpr(), p);
        return null;
    }

    protected R visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, P p) {
        return null;
    }

    protected R visitVariableRefLinked(VariableRefLinked variableRefLinked, P p) {
        return null;
    }

    protected R visitVariableKilled(VariableKilled variableKilled, P p) {
        return null;
    }

    protected R visitMemory(Memory memory, P p) {
        if (memory instanceof GlobalVariable) {
            return this.visitGlobalVariable((GlobalVariable)memory, p);
        }
        if (memory instanceof ArrayAccess) {
            return this.visitVariableArrayAccess((ArrayAccess)memory, p);
        }
        if (memory instanceof StackVariable) {
            return this.visitStackVariable((StackVariable)memory, p);
        }
        if (memory instanceof VariableAddrCalc) {
            return this.visitVariableAddrCalc((VariableAddrCalc)memory, p);
        }
        if (memory instanceof BooleanConstant) {
            return this.visitBooleanConstant((BooleanConstant)((Object)memory), p);
        }
        throw new RuntimeException("Unhandled class: " + memory.getClass());
    }

    protected R visitBooleanConstant(BooleanConstant booleanConstant, P p) {
        return null;
    }

    protected R visitConstant(IntConstant intConstant, P p) {
        return null;
    }

    protected R visitStringConstant(StringConstant stringConstant, P p) {
        return null;
    }

    protected R visitVariableAddrCalc(VariableAddrCalc variableAddrCalc, P p) {
        if (variableAddrCalc instanceof VariablePtrDeref) {
            return this.visitVariablePtrDeref((VariablePtrDeref)variableAddrCalc, p);
        }
        if (variableAddrCalc instanceof VariablePtrOf) {
            return this.visitVariablePtrOf((VariablePtrOf)variableAddrCalc, p);
        }
        throw new RuntimeException("Unhandled class: " + variableAddrCalc.getClass());
    }

    protected R visitVariablePtrOf(VariablePtrOf variablePtrOf, P p) {
        this.visit(variablePtrOf.getExpression(), p);
        return null;
    }

    protected R visitVariableArrayAccess(ArrayAccess arrayAccess, P p) {
        this.visit(arrayAccess.getIndex(), p);
        return null;
    }

    protected R visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, P p) {
        this.visit(variablePtrDeref.getExpression(), p);
        return null;
    }

    protected R visitStackVariable(StackVariable stackVariable, P p) {
        return null;
    }

    protected R visitGlobalVariable(GlobalVariable globalVariable, P p) {
        return null;
    }

    protected R visitIfExpr(IfExpr ifExpr, P p) {
        this.visit(ifExpr.getCondition(), p);
        this.visit(ifExpr.getLeft(), p);
        this.visit(ifExpr.getRight(), p);
        return null;
    }

    protected R visitIntegerExpr(IntegerExpr integerExpr, P p) {
        this.visit(integerExpr.getLeft(), p);
        this.visit(integerExpr.getRight(), p);
        return null;
    }

    protected R visitCompareExpr(CompareExpr compareExpr, P p) {
        this.visit(compareExpr.getLeft(), p);
        this.visit(compareExpr.getRight(), p);
        return null;
    }

    protected R visitStatement(Statement statement, P p) {
        if (statement.isDeleted()) {
            return null;
        }
        if (statement instanceof JumpStmt) {
            return this.visitJumpStmt((JumpStmt)statement, p);
        }
        if (statement instanceof PhiStmt) {
            return this.visitPhiStmt((PhiStmt)statement, p);
        }
        if (statement instanceof AssignmentStmt) {
            return this.visitAssignmentStmt((AssignmentStmt)statement, p);
        }
        if (statement instanceof NopStmt) {
            return this.visitNopStmt((NopStmt)statement, p);
        }
        if (statement instanceof RetStmt) {
            return this.visitRetStmt((RetStmt)statement, p);
        }
        throw new RuntimeException("Unhandled class: " + statement.getClass());
    }

    protected R visitPhiStmt(PhiStmt phiStmt, P p) {
        this.visit(phiStmt.getOption().values(), p);
        this.visit(phiStmt.getVarname(), p);
        return null;
    }

    protected R visitRetStmt(RetStmt retStmt, P p) {
        Map<VariableName, Expression> map = retStmt.getRetval();
        for (VariableName variableName : map.keySet()) {
            this.visit(map.get(variableName), p);
        }
        return null;
    }

    protected R visitJumpStmt(JumpStmt jumpStmt, P p) {
        this.visit(jumpStmt.getExpression(), p);
        return null;
    }

    protected R visitNopStmt(NopStmt nopStmt, P p) {
        return null;
    }

    protected R visitAssignmentStmt(AssignmentStmt assignmentStmt, P p) {
        this.visit(assignmentStmt.getSource(), p);
        this.visit(assignmentStmt.getDestination(), p);
        return null;
    }
}

