/*
 * Decompiled with CFR 0.152.
 */
package cfg.basicblock;

import cfg.IrElement;
import cfg.IrType;
import cfg.basicblock.BbEdge;
import cfg.expression.VariableRefUnlinked;
import cfg.statement.JumpStmt;
import cfg.statement.PhiStmt;
import cfg.statement.Statement;
import cfg.variable.SsaVariable;
import cfg.variable.VariableName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import util.NumPrint;

public class BasicBlock
implements IrElement {
    private final long id;
    private HashMap<Object, PhiStmt> phi = new HashMap();
    private LinkedList<Statement> code = new LinkedList();
    private Set<BbEdge> inlist = new HashSet<BbEdge>();
    private Set<BbEdge> outlist = new HashSet<BbEdge>();

    public BasicBlock(long l) {
        this.id = l;
    }

    public Collection<PhiStmt> getPhis() {
        return this.phi.values();
    }

    public boolean hasPhiFor(VariableName variableName) {
        return this.phi.containsKey(variableName);
    }

    public void insertPhi(SsaVariable ssaVariable) {
        assert (!this.hasPhiFor(ssaVariable.getName()));
        LinkedList<SsaVariable> linkedList = new LinkedList<SsaVariable>();
        linkedList.add(ssaVariable);
        PhiStmt phiStmt = new PhiStmt(ssaVariable);
        for (BbEdge bbEdge : this.inlist) {
            phiStmt.getOption().put(((BasicBlock)bbEdge.getSrc()).getId(), new VariableRefUnlinked(ssaVariable.getName()));
        }
        this.phi.put(ssaVariable.getName(), phiStmt);
        this.code.add(0, phiStmt);
    }

    public long getId() {
        return this.id;
    }

    private long getFirstAddr(Iterator<Statement> iterator) {
        while (iterator.hasNext()) {
            Statement statement = iterator.next();
            if (statement.getOriginal() == null) continue;
            return statement.getOriginal().getAddress();
        }
        throw new RuntimeException("no original statement found");
    }

    public long getFirstAddr() {
        return this.getFirstAddr(this.code.iterator());
    }

    public long getLastAddr() {
        return this.getFirstAddr(this.code.descendingIterator());
    }

    public void addCode(Statement statement) {
        this.code.add(statement);
    }

    public LinkedList<Statement> getCode() {
        return this.code;
    }

    public void setCode(List<Statement> list) {
        this.code = new LinkedList<Statement>(list);
    }

    public void addEdgeOut(BbEdge bbEdge) {
        assert (bbEdge.getSrc() == this);
        this.outlist.add(bbEdge);
    }

    public void addEdgeIn(BbEdge bbEdge) {
        assert (bbEdge.getDst() == this);
        this.inlist.add(bbEdge);
    }

    public Set<BbEdge> getInlist() {
        return this.inlist;
    }

    public Set<BbEdge> getOutlist() {
        return this.outlist;
    }

    public void setOutlist(Set<BbEdge> set) {
        this.outlist = set;
    }

    public void setInlist(Set<BbEdge> set) {
        this.inlist = set;
    }

    public String toString() {
        return NumPrint.toString(this.id);
    }

    @Override
    public IrType getIrType() {
        return IrType.BasicBlock;
    }

    @Override
    public List<? extends IrElement> getChildren() {
        return this.code;
    }

    public static BasicBlock splitAtAddr(BasicBlock basicBlock, long l) {
        if (basicBlock.getFirstAddr() == l) {
            return null;
        }
        BasicBlock basicBlock2 = new BasicBlock(l);
        for (int i = 0; i < basicBlock.getCode().size(); ++i) {
            if (basicBlock.getCode().get(i).getOriginal().getAddress() != l) continue;
            basicBlock2.setCode(basicBlock.getCode().subList(i, basicBlock.getCode().size()));
            basicBlock.getCode().subList(i, basicBlock.getCode().size()).clear();
            basicBlock.addCode(new JumpStmt(0, null, basicBlock2.getId()));
            return basicBlock2;
        }
        throw new RuntimeException("Address not found in BB: " + NumPrint.toString(l));
    }

    public static BasicBlock splitAtStmt(BasicBlock basicBlock, int n) {
        assert (n >= 0);
        assert (n < basicBlock.getCode().size());
        if (n == 0) {
            return null;
        }
        List<Statement> list = basicBlock.getCode().subList(n, basicBlock.getCode().size());
        BasicBlock basicBlock2 = new BasicBlock(((Statement)list.get(0)).getOriginal().getAddress());
        basicBlock2.setCode(list);
        basicBlock.getCode().subList(n, basicBlock.getCode().size()).clear();
        basicBlock.addCode(new JumpStmt(0, null, basicBlock2.getId()));
        HashSet<BbEdge> hashSet = new HashSet<BbEdge>();
        for (BbEdge bbEdge : basicBlock.getOutlist()) {
            hashSet.add(new BbEdge(basicBlock2, (BasicBlock)bbEdge.getDst(), bbEdge.getNr()));
        }
        basicBlock2.setOutlist(hashSet);
        hashSet = new HashSet();
        hashSet.add(new BbEdge(basicBlock, basicBlock2, 0));
        basicBlock.setOutlist(hashSet);
        return basicBlock2;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

