/*
 * Decompiled with CFR 0.152.
 */
package cfg.function;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.statement.JumpStmt;
import cfg.statement.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import util.NumPrint;

public class FunctionGraph
implements DirectedGraph<BasicBlock, BbEdge> {
    private HashMap<Long, BasicBlock> bbs = new HashMap();

    public FunctionGraph(Collection<BasicBlock> collection) {
        for (BasicBlock basicBlock : collection) {
            this.bbs.put(basicBlock.getId(), basicBlock);
        }
        this.updateEdges();
    }

    public void updateEdges() {
        for (BasicBlock basicBlock : this.bbs.values()) {
            basicBlock.setOutlist(new HashSet<BbEdge>());
            basicBlock.setInlist(new HashSet<BbEdge>());
        }
        for (BasicBlock basicBlock : this.bbs.values()) {
            this.linkOutEdges(basicBlock);
        }
    }

    private void linkOutEdges(BasicBlock basicBlock) {
        Statement statement = basicBlock.getCode().get(basicBlock.getCode().size() - 1);
        if (statement instanceof JumpStmt) {
            JumpStmt jumpStmt = (JumpStmt)statement;
            for (int i = 0; i < jumpStmt.getJmpDst().size(); ++i) {
                long l = jumpStmt.getJmpDst().get(i);
                if (!this.bbs.containsKey(l)) {
                    throw new RuntimeException("Basic block not found: " + NumPrint.toString(l) + " (" + basicBlock + ")");
                }
                this.addEdge(basicBlock, this.bbs.get(l), i);
            }
        }
    }

    public BasicBlock getVertex(long l) {
        return this.bbs.get(l);
    }

    private void addEdge(BasicBlock basicBlock, BasicBlock basicBlock2, int n) {
        assert (basicBlock != null);
        assert (basicBlock2 != null);
        new BbEdge(basicBlock, basicBlock2, n);
    }

    public BbEdge addEdge(BasicBlock basicBlock, BasicBlock basicBlock2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean addEdge(BasicBlock basicBlock, BasicBlock basicBlock2, BbEdge bbEdge) {
        assert (bbEdge.getSrc() == basicBlock);
        assert (bbEdge.getDst() == basicBlock2);
        assert (this.bbs.containsValue(basicBlock));
        assert (this.bbs.containsValue(basicBlock2));
        JumpStmt jumpStmt = (JumpStmt)basicBlock.getCode().getLast();
        assert (jumpStmt.getJmpDst().contains(basicBlock2.getId()));
        return true;
    }

    public boolean addVertex(BasicBlock basicBlock) {
        assert (!this.bbs.containsKey(basicBlock.getId()));
        this.bbs.put(basicBlock.getId(), basicBlock);
        return true;
    }

    public boolean containsEdge(BbEdge bbEdge) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean containsEdge(BasicBlock basicBlock, BasicBlock basicBlock2) {
        assert (this.bbs.containsKey(basicBlock.getId()));
        assert (this.bbs.containsKey(basicBlock2.getId()));
        for (BbEdge bbEdge : basicBlock.getOutlist()) {
            if (bbEdge.getDst() != basicBlock2) continue;
            return true;
        }
        return false;
    }

    public boolean containsVertex(BasicBlock basicBlock) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<BbEdge> edgeSet() {
        HashSet<BbEdge> hashSet = new HashSet<BbEdge>();
        for (BasicBlock basicBlock : this.bbs.values()) {
            hashSet.addAll(basicBlock.getOutlist());
        }
        return hashSet;
    }

    public Set<BbEdge> edgesOf(BasicBlock basicBlock) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<BbEdge> getAllEdges(BasicBlock basicBlock, BasicBlock basicBlock2) {
        throw new RuntimeException("Not yet implemented");
    }

    public BbEdge getEdge(BasicBlock basicBlock, BasicBlock basicBlock2) {
        assert (this.bbs.containsValue(basicBlock));
        assert (this.bbs.containsValue(basicBlock2));
        for (BbEdge bbEdge : basicBlock.getOutlist()) {
            if (bbEdge.getDst() != basicBlock2) continue;
            return bbEdge;
        }
        return null;
    }

    public EdgeFactory<BasicBlock, BbEdge> getEdgeFactory() {
        throw new RuntimeException("Not yet implemented");
    }

    public BasicBlock getEdgeSource(BbEdge bbEdge) {
        return (BasicBlock)bbEdge.getSrc();
    }

    public BasicBlock getEdgeTarget(BbEdge bbEdge) {
        return (BasicBlock)bbEdge.getDst();
    }

    public double getEdgeWeight(BbEdge bbEdge) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeAllEdges(Collection<? extends BbEdge> collection) {
        for (BbEdge bbEdge : collection) {
            this.removeEdge(bbEdge);
        }
        return true;
    }

    public Set<BbEdge> removeAllEdges(BasicBlock basicBlock, BasicBlock basicBlock2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeAllVertices(Collection<? extends BasicBlock> collection) {
        for (BasicBlock basicBlock : collection) {
            this.removeVertex(basicBlock);
        }
        return true;
    }

    public boolean removeEdge(BbEdge bbEdge) {
        throw new RuntimeException("Not yet implemented");
    }

    public BbEdge removeEdge(BasicBlock basicBlock, BasicBlock basicBlock2) {
        throw new RuntimeException("Not yet implemented");
    }

    public boolean removeVertex(BasicBlock basicBlock) {
        assert (this.bbs.containsKey(basicBlock.getId()));
        this.bbs.remove(basicBlock.getId());
        return true;
    }

    public Set<BasicBlock> vertexSet() {
        return new HashSet<BasicBlock>(this.bbs.values());
    }

    public int inDegreeOf(BasicBlock basicBlock) {
        return basicBlock.getInlist().size();
    }

    public Set<BbEdge> incomingEdgesOf(BasicBlock basicBlock) {
        return basicBlock.getInlist();
    }

    public int outDegreeOf(BasicBlock basicBlock) {
        throw new RuntimeException("Not yet implemented");
    }

    public Set<BbEdge> outgoingEdgesOf(BasicBlock basicBlock) {
        return basicBlock.getOutlist();
    }
}

