/*
 * Decompiled with CFR 0.152.
 */
package cfg.function;

import ast.type.Type;
import cfg.IrElement;
import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.expression.VariableRefUnlinked;
import cfg.function.FuncProtParam;
import cfg.function.Function;
import cfg.function.FunctionGraph;
import cfg.statement.RetStmt;
import cfg.statement.Statement;
import cfg.unlinker.HllVariable;
import cfg.variable.Array;
import cfg.variable.SsaVariable;
import cfg.variable.Variable;
import cfg.variable.VariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.NumPrint;

public class PrgFunction
extends Function {
    private long addr;
    private FunctionGraph graph;
    private BasicBlock entry;
    private List<BasicBlock> exit = new ArrayList<BasicBlock>();
    private Collection<VariableName> preserves;
    private List<VariableName> returns = new ArrayList<VariableName>();
    private int backupSize;
    private boolean useEbpAsStackAddressing;
    private int stacksize;
    private ArrayList<Variable> param = new ArrayList(0);
    private Map<Long, Array> arrays = new HashMap<Long, Array>();

    public PrgFunction(long l, Collection<BasicBlock> collection) {
        this.addr = l;
        this.entry = null;
        this.graph = new FunctionGraph(collection);
        for (BasicBlock basicBlock : this.graph.vertexSet()) {
            if (basicBlock.getInlist().isEmpty()) {
                if (this.entry != null) {
                    throw new RuntimeException("Function can have only one entry point (" + NumPrint.toString(l) + ")");
                }
                this.entry = basicBlock;
            }
            if (!basicBlock.getOutlist().isEmpty()) continue;
            this.exit.add(basicBlock);
        }
        if (this.entry == null) {
            throw new RuntimeException("Function needs an entry point");
        }
    }

    public void addArray(Array array) {
        this.arrays.put(array.getOffset(), array);
    }

    public Array getArray(long l) {
        return this.arrays.get(l);
    }

    public Collection<Array> getArrays() {
        return this.arrays.values();
    }

    public long getAddr() {
        return this.addr;
    }

    public ArrayList<Variable> getInternParam() {
        return this.param;
    }

    public void setParamCount(int n) {
        assert (this.param.size() == 0);
        this.param = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            SsaVariable ssaVariable = new SsaVariable(new HllVariable("arg" + i), 0);
            this.param.add(ssaVariable);
            this.entry.insertPhi(ssaVariable);
        }
    }

    public int getParamCount() {
        return this.param.size();
    }

    public int getStacksize() {
        return this.stacksize;
    }

    public void setStacksize(int n) {
        this.stacksize = n;
    }

    public void setBackupSize(int n) {
        this.backupSize = n;
    }

    public int getBackupSize() {
        return this.backupSize;
    }

    public boolean useEbpAsStackAddressing() {
        return this.useEbpAsStackAddressing;
    }

    public void setUseEbpAsStackAddressing(boolean bl) {
        this.useEbpAsStackAddressing = bl;
    }

    @Override
    public Collection<VariableName> getPreserves() {
        return this.preserves;
    }

    public void setPreserves(Collection<VariableName> collection) {
        this.preserves = collection;
    }

    public void addReturnVariable(VariableName variableName) {
        if (this.returns.contains(variableName)) {
            for (BasicBlock basicBlock : this.exit) {
                Statement statement = basicBlock.getCode().getLast();
                assert (statement.getIrType() == IrType.RetStmt);
                RetStmt retStmt = (RetStmt)statement;
                assert (retStmt.getRetval().containsKey(variableName));
            }
        } else {
            for (BasicBlock basicBlock : this.exit) {
                Statement statement = basicBlock.getCode().getLast();
                assert (statement.getIrType() == IrType.RetStmt);
                RetStmt retStmt = (RetStmt)statement;
                retStmt.getRetval().put(variableName, new VariableRefUnlinked(variableName));
            }
            this.returns.add(variableName);
        }
    }

    @Override
    public List<VariableName> getReturns() {
        return this.returns;
    }

    public String toString() {
        return "f" + Long.toHexString(this.getAddr());
    }

    public BasicBlock getEntry() {
        return this.entry;
    }

    public Collection<BasicBlock> getExit() {
        return this.exit;
    }

    public FunctionGraph getGraph() {
        return this.graph;
    }

    @Override
    public IrType getIrType() {
        return IrType.FuncProgram;
    }

    @Override
    public List<? extends IrElement> getChildren() {
        return new ArrayList<BasicBlock>(this.graph.vertexSet());
    }

    @Override
    public Type getReturnType() {
        return Type.Generic;
    }

    @Override
    public List<FuncProtParam> getParam() {
        ArrayList<FuncProtParam> arrayList = new ArrayList<FuncProtParam>(this.getParamCount());
        for (Variable variable : this.getInternParam()) {
            arrayList.add(new FuncProtParam(variable.getName().toString(), Type.Generic));
        }
        return arrayList;
    }
}

