/*
 * Decompiled with CFR 0.152.
 */
package cfg.function.argument;

import cfg.IrItr;
import cfg.IrReplaceExprTraverser;
import cfg.expression.Expression;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRefUnlinked;
import cfg.function.PrgFunction;
import cfg.function.argument.FuncVariables;
import cfg.matcher.VarIntopConstMatcher;
import cfg.variable.Variable;
import cfg.variable.VariablePtrDeref;
import java.util.Collection;

public class ArgumentPtrReplacer
extends IrReplaceExprTraverser<Void> {
    private PrgFunction func = null;

    public static void process(Collection<PrgFunction> collection) {
        ArgumentPtrReplacer argumentPtrReplacer = new ArgumentPtrReplacer();
        argumentPtrReplacer.visitCollection(collection, null);
    }

    @Override
    protected void visitPrgFunction(PrgFunction prgFunction, Void void_) {
        assert (this.func == null);
        this.func = prgFunction;
        super.visitPrgFunction(prgFunction, void_);
        assert (this.func == prgFunction);
        this.func = null;
    }

    @Override
    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Void void_) {
        VarIntopConstMatcher varIntopConstMatcher = new VarIntopConstMatcher();
        varIntopConstMatcher.parse(new IrItr(variablePtrDeref.getExpression()));
        if (!varIntopConstMatcher.hasError() && varIntopConstMatcher.getVar() == FuncVariables.argPtr) {
            if (varIntopConstMatcher.getOp() != IntegerOp.Add) {
                throw new RuntimeException("Expect addition");
            }
            if (varIntopConstMatcher.getValue() < 0L) {
                throw new RuntimeException("Expect positive offset");
            }
            if (varIntopConstMatcher.getValue() % 4L != 0L) {
                throw new RuntimeException("Expect 4 byte data types");
            }
            Variable variable = this.func.getInternParam().get((int)varIntopConstMatcher.getValue() / 4);
            return new VariableRefUnlinked(variable.getName());
        }
        return super.visitVariablePtrDeref(variablePtrDeref, void_);
    }
}

