/*
 * Decompiled with CFR 0.152.
 */
package cfg.function.argument;

import cfg.IntConstant;
import cfg.IrItr;
import cfg.IrReplaceExprTraverser;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.PrgFunction;
import cfg.function.argument.FuncVariables;
import cfg.matcher.VarIntopConstMatcher;
import cfg.variable.SsaVariable;
import disassembler.diStorm3.Registers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class EspEbpReplacer
extends IrReplaceExprTraverser<Void> {
    private PrgFunction func = null;
    private Set<Long> locPtrOffset = new HashSet<Long>();

    public static Set<Long> process(PrgFunction prgFunction) {
        EspEbpReplacer espEbpReplacer = new EspEbpReplacer();
        espEbpReplacer.visit(prgFunction, null);
        return espEbpReplacer.getLocPtrOffset();
    }

    public static void process(Collection<? extends Function> collection) {
        EspEbpReplacer espEbpReplacer = new EspEbpReplacer();
        espEbpReplacer.visitCollection(collection, null);
    }

    public Set<Long> getLocPtrOffset() {
        return this.locPtrOffset;
    }

    @Override
    protected void visitPrgFunction(PrgFunction prgFunction, Void void_) {
        assert (this.func == null);
        this.func = prgFunction;
        SsaVariable ssaVariable = new SsaVariable(FuncVariables.argPtr, 0);
        SsaVariable ssaVariable2 = new SsaVariable(FuncVariables.locPtr, 0);
        this.func.getEntry().insertPhi(ssaVariable);
        this.func.getEntry().insertPhi(ssaVariable2);
        super.visitPrgFunction(prgFunction, void_);
        assert (this.func == prgFunction);
        this.func = null;
    }

    @Override
    protected Expression visitIntegerExpr(IntegerExpr integerExpr, Void void_) {
        VarIntopConstMatcher varIntopConstMatcher = new VarIntopConstMatcher();
        varIntopConstMatcher.parse(new IrItr(integerExpr));
        if (varIntopConstMatcher.hasError() || !(varIntopConstMatcher.getVar() instanceof Registers)) {
            return super.visitIntegerExpr(integerExpr, void_);
        }
        switch ((Registers)varIntopConstMatcher.getVar()) {
            case EBP: {
                if (this.func.useEbpAsStackAddressing()) {
                    return this.doEbp(varIntopConstMatcher.getOp(), varIntopConstMatcher.getValue());
                }
                return super.visitIntegerExpr(integerExpr, void_);
            }
            case ESP: {
                return this.doEsp(varIntopConstMatcher.getOp(), varIntopConstMatcher.getValue());
            }
        }
        return super.visitIntegerExpr(integerExpr, void_);
    }

    private Expression doEsp(IntegerOp integerOp, long l) {
        if (integerOp != IntegerOp.Add) {
            throw new RuntimeException("Unexpected operation: " + (Object)((Object)integerOp));
        }
        if (l < 0L) {
            throw new RuntimeException("Unexpected value: " + l);
        }
        int n = this.func.getBackupSize() + this.func.getStacksize() + 4;
        if (l >= (long)n) {
            return new IntegerExpr(new VariableRefUnlinked(FuncVariables.argPtr), new IntConstant(l -= (long)n), IntegerOp.Add);
        }
        if (l >= (long)this.func.getStacksize()) {
            throw new RuntimeException("Accessing restricted area: " + l);
        }
        this.locPtrOffset.add(l);
        return new IntegerExpr(new VariableRefUnlinked(FuncVariables.locPtr), new IntConstant(l), IntegerOp.Add);
    }

    private Expression doEbp(IntegerOp integerOp, long l) {
        if (integerOp != IntegerOp.Add && integerOp != IntegerOp.Sub) {
            throw new RuntimeException("Unexpected operation: " + (Object)((Object)integerOp));
        }
        if (integerOp == IntegerOp.Sub) {
            l = -l;
        }
        if (l >= 8L) {
            assert ((l -= 8L) >= 0L);
            return new IntegerExpr(new VariableRefUnlinked(FuncVariables.argPtr), new IntConstant(l), IntegerOp.Add);
        }
        if ((l = l + (long)this.func.getBackupSize() + (long)this.func.getStacksize() - 4L) < 0L) {
            throw new RuntimeException("Accessing nomansland: " + l);
        }
        if (l >= (long)this.func.getStacksize()) {
            throw new RuntimeException("Accessing restricted area: " + l);
        }
        this.locPtrOffset.add(l);
        return new IntegerExpr(new VariableRefUnlinked(FuncVariables.locPtr), new IntConstant(l), IntegerOp.Add);
    }
}

