/*
 * Decompiled with CFR 0.152.
 */
package cfg.function.argument;

import cfg.IrItr;
import cfg.IrTraverser;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.function.PrgFunction;
import cfg.matcher.VarIntopConstMatcher;
import disassembler.diStorm3.Registers;

public class FunctionArgumentCounter
extends IrTraverser<Void, PrgFunction> {
    private int argMax = 0;

    public static void process(Object object) {
        FunctionArgumentCounter functionArgumentCounter = new FunctionArgumentCounter();
        functionArgumentCounter.visit(object, null);
    }

    @Override
    protected Void visitPrgFunction(PrgFunction prgFunction, PrgFunction prgFunction2) {
        assert (this.argMax == 0);
        assert (prgFunction2 == null);
        super.visitPrgFunction(prgFunction, prgFunction);
        prgFunction.setParamCount((this.argMax + 3) / 4);
        this.argMax = 0;
        return null;
    }

    @Override
    protected Void visitIntegerExpr(IntegerExpr integerExpr, PrgFunction prgFunction) {
        VarIntopConstMatcher varIntopConstMatcher = new VarIntopConstMatcher();
        varIntopConstMatcher.parse(new IrItr(integerExpr));
        if (varIntopConstMatcher.hasError() || !(varIntopConstMatcher.getVar() instanceof Registers)) {
            return (Void)super.visitIntegerExpr(integerExpr, prgFunction);
        }
        switch ((Registers)varIntopConstMatcher.getVar()) {
            case EBP: {
                if (!prgFunction.useEbpAsStackAddressing()) break;
                this.doEbp(varIntopConstMatcher.getOp(), varIntopConstMatcher.getValue());
                break;
            }
            case ESP: {
                this.doEsp(varIntopConstMatcher.getOp(), varIntopConstMatcher.getValue(), prgFunction);
                break;
            }
            default: {
                return (Void)super.visitIntegerExpr(integerExpr, prgFunction);
            }
        }
        return null;
    }

    private void doEsp(IntegerOp integerOp, long l, PrgFunction prgFunction) {
        if (integerOp != IntegerOp.Add) {
            throw new RuntimeException("Unexpected operation: " + (Object)((Object)integerOp));
        }
        if (l < 0L) {
            throw new RuntimeException("Unexpected value: " + l);
        }
        int n = prgFunction.getBackupSize() + prgFunction.getStacksize() + 4;
        if (l >= (long)n) {
            this.argMax = Math.max(this.argMax, (int)(l -= (long)n) + 4);
        }
    }

    private void doEbp(IntegerOp integerOp, long l) {
        if (integerOp != IntegerOp.Add && integerOp != IntegerOp.Sub) {
            throw new RuntimeException("Unexpected operation: " + (Object)((Object)integerOp));
        }
        if (integerOp == IntegerOp.Sub) {
            l = -l;
        }
        if (l >= 8L) {
            assert ((l -= 8L) >= 0L);
            this.argMax = Math.max(this.argMax, (int)l + 4);
        }
    }
}

