/*
 * Decompiled with CFR 0.152.
 */
package cfg.function.library.stdio;

import cfg.Application;
import cfg.Assignable;
import cfg.IntConstant;
import cfg.IrElement;
import cfg.IrReplaceExprTraverser;
import cfg.IrType;
import cfg.StringConstant;
import cfg.basicblock.BasicBlock;
import cfg.expression.CallExpr;
import cfg.expression.CallExprLinked;
import cfg.expression.Expression;
import cfg.expression.VariableRefLinked;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.SysFunction;
import cfg.function.library.stdio.FormatToken;
import cfg.function.library.stdio.StdioStringParser;
import cfg.function.library.stdio.StringFormat;
import cfg.function.system.SystemFunctions;
import cfg.statement.AssignmentStmt;
import cfg.statement.RetStmt;
import cfg.statement.Statement;
import cfg.variable.Array;
import cfg.variable.ArrayAccess;
import cfg.variable.VariableName;
import elfreader.ElfReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import knowledge.KnowOwner;
import knowledge.KnowledgeBase;

public class PrintfReplacer
extends IrReplaceExprTraverser<Void> {
    private Map<Long, PrgFunction> printf;
    private ElfReader elf;
    private KnowOwner ko;
    private PrgFunction acfunc = null;

    public static void process(Application application) {
        HashMap<Long, PrgFunction> hashMap = new HashMap<Long, PrgFunction>();
        PrintfReplacer printfReplacer = new PrintfReplacer(application.getKb(), hashMap, application.getElfReader());
        printfReplacer.visitCollection(application.getFunctions(), null);
        for (PrgFunction prgFunction : hashMap.values()) {
            application.getFunctions().add(prgFunction);
        }
    }

    public PrintfReplacer(KnowledgeBase knowledgeBase, Map<Long, PrgFunction> map, ElfReader elfReader) {
        this.printf = map;
        this.elf = elfReader;
        this.ko = (KnowOwner)knowledgeBase.getEntry(KnowOwner.class);
    }

    @Override
    protected void visitPrgFunction(PrgFunction prgFunction, Void void_) {
        assert (this.acfunc == null);
        this.acfunc = prgFunction;
        super.visitPrgFunction(prgFunction, void_);
        assert (this.acfunc == prgFunction);
        this.acfunc = null;
    }

    @Override
    protected Expression visitCallExprLinked(CallExprLinked callExprLinked, Void void_) {
        if (callExprLinked.getFunc().getIrType() != IrType.FuncLibrary) {
            return callExprLinked;
        }
        LibFunction libFunction = (LibFunction)callExprLinked.getFunc();
        if ("printf".equals(libFunction.getName())) {
            long l = StdioStringParser.getFormatStringAddr(callExprLinked, this.ko);
            PrgFunction prgFunction = this.printf.get(l);
            if (prgFunction == null) {
                prgFunction = this.createPrintfFunc(l);
                this.printf.put(prgFunction.getAddr(), prgFunction);
            }
            ArrayList<Expression> arrayList = new ArrayList<Expression>(prgFunction.getParamCount());
            for (int i = 0; i < prgFunction.getParamCount(); ++i) {
                Array array = this.acfunc.getArray(i + 1);
                assert (array != null);
                ArrayAccess arrayAccess = new ArrayAccess(array, new IntConstant(0L));
                arrayList.add(arrayAccess);
            }
            CallExprLinked callExprLinked2 = new CallExprLinked(prgFunction);
            callExprLinked2.setParam(arrayList);
            return callExprLinked2;
        }
        if ("puts".equals(libFunction.getName())) {
            long l = StdioStringParser.getFormatStringAddr(callExprLinked, this.ko);
            PrgFunction prgFunction = this.printf.get(l);
            if (prgFunction == null) {
                prgFunction = this.createPutsFunc(l);
                this.printf.put(prgFunction.getAddr(), prgFunction);
            }
            CallExprLinked callExprLinked3 = new CallExprLinked(prgFunction);
            return callExprLinked3;
        }
        if ("putchar".equals(libFunction.getName())) {
            long l = StdioStringParser.getFormatStringAddr(callExprLinked, this.ko);
            if (l == 10L) {
                return new CallExprLinked(SystemFunctions.writeNl);
            }
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            StringConstant stringConstant = new StringConstant(String.valueOf((char)l));
            arrayList.add(stringConstant);
            SysFunction sysFunction = SystemFunctions.writeStr;
            CallExprLinked callExprLinked4 = new CallExprLinked(sysFunction);
            callExprLinked4.setParam(arrayList);
            return callExprLinked4;
        }
        return callExprLinked;
    }

    private PrgFunction createPutsFunc(long l) {
        BasicBlock basicBlock = new BasicBlock(l);
        basicBlock.addCode(new RetStmt(0, null, new HashMap<VariableName, Expression>()));
        this.elf.seek(l);
        String string = this.elf.readString();
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>();
        arrayList.add(basicBlock);
        PrgFunction prgFunction = new PrgFunction(l, arrayList);
        prgFunction.setParamCount(0);
        prgFunction.setPreserves(new HashSet<VariableName>());
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        Expression expression = new StringConstant(string);
        arrayList2.add(expression);
        SysFunction sysFunction = SystemFunctions.writeStr;
        IrElement irElement = new CallExprLinked(sysFunction);
        irElement.setParam(arrayList2);
        AssignmentStmt assignmentStmt = new AssignmentStmt(basicBlock.getCode().size(), (List<Assignable>)new ArrayList<Assignable>(), (Expression)irElement);
        basicBlock.getCode().add(basicBlock.getCode().size() - 1, assignmentStmt);
        arrayList2 = new ArrayList();
        sysFunction = SystemFunctions.writeNl;
        expression = new CallExprLinked(sysFunction);
        ((CallExpr)expression).setParam(arrayList2);
        irElement = new AssignmentStmt(basicBlock.getCode().size(), new ArrayList<Assignable>(), expression);
        basicBlock.getCode().add(basicBlock.getCode().size() - 1, (Statement)irElement);
        return prgFunction;
    }

    private PrgFunction createPrintfFunc(long l) {
        BasicBlock basicBlock = new BasicBlock(l);
        basicBlock.addCode(new RetStmt(0, null, new HashMap<VariableName, Expression>()));
        this.elf.seek(l);
        String string = this.elf.readString();
        List<FormatToken> list = StdioStringParser.parseFormat(string);
        ArrayList<BasicBlock> arrayList = new ArrayList<BasicBlock>();
        arrayList.add(basicBlock);
        PrgFunction prgFunction = new PrgFunction(l, arrayList);
        prgFunction.setParamCount(StdioStringParser.getArgCount(list));
        prgFunction.setPreserves(new HashSet<VariableName>());
        int n = 0;
        for (FormatToken formatToken : list) {
            SysFunction sysFunction;
            Expression expression;
            ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
            switch (formatToken.getType()) {
                case Integer: {
                    expression = new VariableRefLinked(prgFunction.getInternParam().get(n));
                    ++n;
                    arrayList2.add(expression);
                    sysFunction = SystemFunctions.writeInt;
                    break;
                }
                case String: {
                    expression = new StringConstant(((StringFormat)formatToken).getContent());
                    arrayList2.add(expression);
                    sysFunction = SystemFunctions.writeStr;
                    break;
                }
                case Newline: {
                    sysFunction = SystemFunctions.writeNl;
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled format token type: " + (Object)((Object)formatToken.getType()));
                }
            }
            expression = new CallExprLinked(sysFunction);
            ((CallExpr)expression).setParam(arrayList2);
            AssignmentStmt assignmentStmt = new AssignmentStmt(basicBlock.getCode().size(), new ArrayList<Assignable>(), expression);
            basicBlock.getCode().add(basicBlock.getCode().size() - 1, assignmentStmt);
        }
        return prgFunction;
    }
}

