/*
 * Decompiled with CFR 0.152.
 */
package cfg.function.library.stdio;

import cfg.Application;
import cfg.Assignable;
import cfg.IntConstant;
import cfg.IrTraverser;
import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.expression.CallExprLinked;
import cfg.expression.Expression;
import cfg.function.LibFunction;
import cfg.function.library.stdio.FormatToken;
import cfg.function.library.stdio.StdioStringParser;
import cfg.function.system.SystemFunctions;
import cfg.statement.AssignmentStmt;
import cfg.statement.Statement;
import cfg.variable.VariablePtrDeref;
import elfreader.ElfReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import knowledge.KnowOwner;
import knowledge.KnowledgeBase;
import reduction.ExprCopy;
import util.Pair;

public class ScanfReplacer
extends IrTraverser<Void, LinkedList<Pair<Integer, Statement>>> {
    private ElfReader elf;
    private KnowOwner ko;

    public static void process(Application application) {
        ScanfReplacer scanfReplacer = new ScanfReplacer(application.getKb(), application.getElfReader());
        scanfReplacer.visit(application.getFunctions(), null);
    }

    public ScanfReplacer(KnowledgeBase knowledgeBase, ElfReader elfReader) {
        this.elf = elfReader;
        this.ko = (KnowOwner)knowledgeBase.getEntry(KnowOwner.class);
    }

    @Override
    protected Void visitBasicBlock(BasicBlock basicBlock, LinkedList<Pair<Integer, Statement>> linkedList) {
        assert (linkedList == null);
        linkedList = new LinkedList();
        super.visitBasicBlock(basicBlock, linkedList);
        Iterator<Pair<Integer, Statement>> iterator = linkedList.descendingIterator();
        while (iterator.hasNext()) {
            Pair<Integer, Statement> pair = iterator.next();
            basicBlock.getCode().add(pair.getFirst(), pair.getSecond());
        }
        return null;
    }

    @Override
    protected Void visitCallExprLinked(CallExprLinked callExprLinked, LinkedList<Pair<Integer, Statement>> linkedList) {
        if (callExprLinked.getFunc().getIrType() != IrType.FuncLibrary) {
            return null;
        }
        LibFunction libFunction = (LibFunction)callExprLinked.getFunc();
        if (!"__isoc99_scanf".equals(libFunction.getName())) {
            return null;
        }
        long l = StdioStringParser.getFormatStringAddr(callExprLinked, this.ko);
        int n = this.createPrintfFunc(l);
        AssignmentStmt assignmentStmt = (AssignmentStmt)this.ko.getExprOwner(callExprLinked);
        BasicBlock basicBlock = this.ko.getStmtOwner(assignmentStmt);
        int n2 = basicBlock.getCode().indexOf(assignmentStmt);
        for (int i = 0; i < n; ++i) {
            Expression expression = StdioStringParser.getArrayWriteExpr(basicBlock.getCode(), n2 - 1, i + 1);
            expression = ExprCopy.copy(expression);
            VariablePtrDeref variablePtrDeref = new VariablePtrDeref(expression);
            LinkedList<Assignable> linkedList2 = new LinkedList<Assignable>();
            linkedList2.add(variablePtrDeref);
            AssignmentStmt assignmentStmt2 = new AssignmentStmt(0, linkedList2, new CallExprLinked(SystemFunctions.readInt));
            linkedList.add(new Pair<Integer, AssignmentStmt>(n2 + 1, assignmentStmt2));
        }
        assignmentStmt.setSource(new IntConstant(n));
        return null;
    }

    private int createPrintfFunc(long l) {
        this.elf.seek(l);
        String string = this.elf.readString();
        List<FormatToken> list = StdioStringParser.parseFormat(string);
        int n = 0;
        block5: for (FormatToken formatToken : list) {
            switch (formatToken.getType()) {
                case Integer: {
                    ++n;
                    continue block5;
                }
                case String: {
                    throw new RuntimeException("Unhandled format token type: " + (Object)((Object)formatToken.getType()));
                }
                case Newline: {
                    throw new RuntimeException("Unhandled format token type: " + (Object)((Object)formatToken.getType()));
                }
            }
            throw new RuntimeException("Unhandled format token type: " + (Object)((Object)formatToken.getType()));
        }
        return n;
    }
}

