/*
 * Decompiled with CFR 0.152.
 */
package cfg.function.library.stdio;

import cfg.IntConstant;
import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.expression.CallExprLinked;
import cfg.expression.Expression;
import cfg.expression.VariableRefLinked;
import cfg.function.library.stdio.FormatToken;
import cfg.function.library.stdio.IntegerFormat;
import cfg.function.library.stdio.NewlineFormat;
import cfg.function.library.stdio.StringFormat;
import cfg.statement.AssignmentStmt;
import cfg.statement.Statement;
import cfg.variable.ArrayAccess;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import knowledge.KnowOwner;

public class StdioStringParser {
    public static List<FormatToken> parseFormat(String string) {
        ArrayList<FormatToken> arrayList = new ArrayList<FormatToken>();
        String string2 = "";
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '%': {
                    if (string2.length() > 0) {
                        arrayList.add(new StringFormat(string2));
                        string2 = "";
                    }
                    if (string.charAt(++i) != 'i') {
                        throw new RuntimeException("format to complicated for me: " + string);
                    }
                    arrayList.add(new IntegerFormat());
                    continue block4;
                }
                case '\n': {
                    if (string2.length() > 0) {
                        arrayList.add(new StringFormat(string2));
                        string2 = "";
                    }
                    arrayList.add(new NewlineFormat());
                    continue block4;
                }
                default: {
                    string2 = string2 + string.charAt(i);
                }
            }
        }
        if (string2.length() > 0) {
            arrayList.add(new StringFormat(string2));
        }
        return arrayList;
    }

    public static int getArgCount(List<FormatToken> list) {
        int n = 0;
        for (FormatToken formatToken : list) {
            switch (formatToken.getType()) {
                case Integer: {
                    ++n;
                }
            }
        }
        return n;
    }

    public static long getFormatStringAddr(CallExprLinked callExprLinked, KnowOwner knowOwner) {
        assert (callExprLinked.getParam().size() >= 1);
        Expression expression = null;
        Statement statement = knowOwner.getExprOwner(callExprLinked);
        BasicBlock basicBlock = knowOwner.getStmtOwner(statement);
        expression = StdioStringParser.getArrayWriteExpr(basicBlock.getCode(), basicBlock.getCode().indexOf(statement) - 1, 0);
        assert (expression != null);
        long l = StdioStringParser.followAssignements(expression, knowOwner);
        return l;
    }

    private static long followAssignements(Expression expression, KnowOwner knowOwner) {
        switch (expression.getIrType()) {
            case IntConstant: {
                return ((IntConstant)expression).getValue();
            }
            case VariableRefLinked: {
                Statement statement = knowOwner.getVarOwner(((VariableRefLinked)expression).getReference());
                if (statement instanceof AssignmentStmt) {
                    return StdioStringParser.followAssignements(((AssignmentStmt)statement).getSource(), knowOwner);
                }
                throw new RuntimeException("expected assignement: " + statement);
            }
        }
        throw new RuntimeException("unhandled expression type: " + knowOwner.getExprOwner(expression));
    }

    public static Expression getArrayWriteExpr(LinkedList<Statement> linkedList, int n, int n2) {
        for (int i = n; i >= 0; --i) {
            AssignmentStmt assignmentStmt;
            Statement statement = linkedList.get(i);
            if (statement.getIrType() != IrType.AssignmentStmt || (assignmentStmt = (AssignmentStmt)statement).getDestination().size() != 1 || !(assignmentStmt.getDestination().get(0) instanceof ArrayAccess)) continue;
            ArrayAccess arrayAccess = (ArrayAccess)assignmentStmt.getDestination().get(0);
            assert (arrayAccess.getIndex() instanceof IntConstant);
            assert (((IntConstant)arrayAccess.getIndex()).getValue() == 0L);
            if (arrayAccess.getBase().getOffset() != (long)n2) continue;
            return assignmentStmt.getSource();
        }
        return null;
    }
}

