/*
 * Decompiled with CFR 0.152.
 */
package cfg.function.system;

import ast.type.Type;
import cfg.function.FuncProtParam;
import cfg.function.SysFunction;
import cfg.variable.VariableName;
import disassembler.diStorm3.Registers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SystemFunctions {
    public static final SysFunction push = new SysFunction("push", SystemFunctions.makeParam("x", Type.Number), SystemFunctions.makeList(), Type.Void);
    public static final SysFunction pop = new SysFunction("pop", new ArrayList<FuncProtParam>(), SystemFunctions.makeList(), Type.Number);
    public static final SysFunction halt = new SysFunction("halt", new ArrayList<FuncProtParam>(), SystemFunctions.makeList(), Type.Void);
    public static final SysFunction castInt64 = new SysFunction("int64", SystemFunctions.makeParam("x", Type.Number), SystemFunctions.makeList(), Type.Number);
    public static final SysFunction funcMemcpy = new SysFunction("memcpy", null, SystemFunctions.makeList(Registers.ECX, Registers.EDI, Registers.ESI), Type.Void);
    public static final SysFunction writeInt = new SysFunction("writeInt", SystemFunctions.makeParam("value", Type.Number), SystemFunctions.makeList(), Type.Void);
    public static final SysFunction writeStr = new SysFunction("writeStr", SystemFunctions.makeParam("text", Type.String), SystemFunctions.makeList(), Type.Void);
    public static final SysFunction writeNl = new SysFunction("writeNl", new ArrayList<FuncProtParam>(), SystemFunctions.makeList(), Type.Void);
    public static final SysFunction readInt = new SysFunction("readInt", new ArrayList<FuncProtParam>(), SystemFunctions.makeList(), Type.Integer);
    public static final SysFunction ptrNew = new SysFunction("ptrMalloc", SystemFunctions.makeParam("size", Type.Integer), SystemFunctions.makeList(), Type.Pointer);
    public static final SysFunction ptrDestroy = new SysFunction("ptrFree", SystemFunctions.makeParam("ptr", Type.Pointer), SystemFunctions.makeList(), Type.Void);

    public Set<SysFunction> getAll() {
        HashSet<SysFunction> hashSet = new HashSet<SysFunction>();
        hashSet.add(push);
        hashSet.add(pop);
        hashSet.add(halt);
        hashSet.add(castInt64);
        hashSet.add(funcMemcpy);
        hashSet.add(writeInt);
        hashSet.add(writeStr);
        hashSet.add(writeNl);
        hashSet.add(readInt);
        return hashSet;
    }

    private static ArrayList<FuncProtParam> makeParam(String string, Type type) {
        ArrayList<FuncProtParam> arrayList = new ArrayList<FuncProtParam>(1);
        arrayList.add(new FuncProtParam(string, type));
        return arrayList;
    }

    private static List<VariableName> makeList(Registers registers, Registers registers2, Registers registers3) {
        ArrayList<VariableName> arrayList = new ArrayList<VariableName>(3);
        arrayList.add(registers);
        arrayList.add(registers2);
        arrayList.add(registers3);
        return arrayList;
    }

    private static List<VariableName> makeList() {
        return new ArrayList<VariableName>();
    }
}

