/*
 * Decompiled with CFR 0.152.
 */
package cfg.linker;

import cfg.IrTraverser;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.expression.Expression;
import cfg.expression.VariableRef;
import cfg.expression.VariableRefLinked;
import cfg.expression.VariableRefUnlinked;
import cfg.statement.PhiStmt;
import cfg.variable.SsaVariable;
import cfg.variable.VariableName;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class DefUseKillVisitor
extends IrTraverser<Void, BasicBlock> {
    private HashMap<BasicBlock, HashSet<VariableName>> use = new HashMap();
    private HashMap<BasicBlock, HashSet<VariableName>> def = new HashMap();
    private HashMap<BasicBlock, HashSet<VariableName>> kill = new HashMap();
    private HashMap<VariableName, HashSet<BasicBlock>> blocks = new HashMap();

    public HashMap<BasicBlock, HashSet<VariableName>> getUse() {
        return this.use;
    }

    public HashMap<BasicBlock, HashSet<VariableName>> getDef() {
        return this.def;
    }

    public HashMap<BasicBlock, HashSet<VariableName>> getKill() {
        return this.kill;
    }

    public HashMap<VariableName, HashSet<BasicBlock>> getBlocks() {
        return this.blocks;
    }

    @Override
    protected Void visitBasicBlock(BasicBlock basicBlock, BasicBlock basicBlock2) {
        assert (basicBlock2 == null);
        this.use.put(basicBlock, new HashSet());
        this.def.put(basicBlock, new HashSet());
        this.kill.put(basicBlock, new HashSet());
        super.visitBasicBlock(basicBlock, basicBlock);
        this.visitFollowingPhi(basicBlock);
        return null;
    }

    private void visitFollowingPhi(BasicBlock basicBlock) {
        for (BbEdge bbEdge : basicBlock.getOutlist()) {
            Collection<PhiStmt> collection = ((BasicBlock)bbEdge.getDst()).getPhis();
            for (PhiStmt phiStmt : collection) {
                Expression expression = phiStmt.getOption().get(basicBlock.getId());
                assert (expression != null);
                this.visit(expression, basicBlock);
                this.visit(phiStmt.getVarname(), basicBlock);
            }
        }
    }

    @Override
    protected Void visitPhiStmt(PhiStmt phiStmt, BasicBlock basicBlock) {
        return null;
    }

    @Override
    protected Void visitSsaVariable(SsaVariable ssaVariable, BasicBlock basicBlock) {
        this.def.get(basicBlock).add(ssaVariable.getName());
        this.kill.get(basicBlock).add(ssaVariable.getName());
        if (!this.blocks.containsKey(ssaVariable.getName())) {
            this.blocks.put(ssaVariable.getName(), new HashSet());
        }
        this.blocks.get(ssaVariable.getName()).add(basicBlock);
        return (Void)super.visitSsaVariable(ssaVariable, basicBlock);
    }

    @Override
    protected Void visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, BasicBlock basicBlock) {
        this.visitVarRef(variableRefUnlinked, basicBlock);
        return (Void)super.visitVariableRefUnlinked(variableRefUnlinked, basicBlock);
    }

    @Override
    protected Void visitVariableRefLinked(VariableRefLinked variableRefLinked, BasicBlock basicBlock) {
        this.visitVarRef(variableRefLinked, basicBlock);
        return (Void)super.visitVariableRefLinked(variableRefLinked, basicBlock);
    }

    private void visitVarRef(VariableRef variableRef, BasicBlock basicBlock) {
        if (!this.def.get(basicBlock).contains(variableRef.getName())) {
            this.use.get(basicBlock).add(variableRef.getName());
            if (!this.blocks.containsKey(variableRef.getName())) {
                this.blocks.put(variableRef.getName(), new HashSet());
            }
        }
    }

    private void print(BasicBlock basicBlock, PrintStream printStream) {
        printStream.println(basicBlock);
        printStream.print("def: ");
        this.printVarList((Collection<VariableName>)this.def.get(basicBlock), printStream);
        printStream.print("use: ");
        this.printVarList((Collection<VariableName>)this.use.get(basicBlock), printStream);
        printStream.print("kill: ");
        this.printVarList((Collection<VariableName>)this.kill.get(basicBlock), printStream);
    }

    private void printVarList(Collection<VariableName> collection, PrintStream printStream) {
        for (VariableName variableName : collection) {
            printStream.print(variableName);
            printStream.print(", ");
        }
        printStream.println();
    }
}

