/*
 * Decompiled with CFR 0.152.
 */
package cfg.linker;

import cfg.Application;
import cfg.IrReplaceExprTraverser;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.Expression;
import cfg.function.PrgFunction;
import knowledge.KnowFuncByAddr;
import knowledge.KnowledgeBase;

public class FunctionLinker
extends IrReplaceExprTraverser<Void> {
    private KnowFuncByAddr funcAddr;

    public static void link(Application application) {
        FunctionLinker functionLinker = new FunctionLinker(application.getKb());
        functionLinker.visitCollection(application.getFunctions(), null);
    }

    public FunctionLinker(KnowledgeBase knowledgeBase) {
        this.funcAddr = (KnowFuncByAddr)knowledgeBase.getEntry(KnowFuncByAddr.class);
    }

    @Override
    protected Expression visitCallExprPointer(CallExprPointer callExprPointer, Void void_) {
        return super.visitCallExprPointer(callExprPointer, void_);
    }

    @Override
    protected Expression visitCallExprUnlinked(CallExprUnlinked callExprUnlinked, Void void_) {
        PrgFunction prgFunction = this.funcAddr.findFunction(callExprUnlinked.getAddr());
        if (prgFunction == null) {
            throw new RuntimeException("Function not found: " + callExprUnlinked);
        }
        CallExprLinked callExprLinked = new CallExprLinked(prgFunction);
        callExprLinked.setParam(callExprUnlinked.getParam());
        return callExprLinked;
    }
}

