/*
 * Decompiled with CFR 0.152.
 */
package cfg.linker;

import cfg.IrReplaceExprTraverser;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.expression.Expression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.PrgFunction;
import cfg.linker.IntraBbVariableLinker;
import cfg.statement.PhiStmt;
import cfg.variable.VariableName;
import java.util.Collection;
import java.util.HashMap;

public class InterBbVariableLinker
extends IrReplaceExprTraverser<BasicBlock> {
    private IntraBbVariableLinker link;
    private HashMap<BasicBlock, BasicBlock> idom;
    private PrgFunction func;
    private boolean linkUnlinked;
    private boolean linkKilled;

    public static void link(IntraBbVariableLinker intraBbVariableLinker, HashMap<BasicBlock, BasicBlock> hashMap, Function function, boolean bl, boolean bl2) {
        InterBbVariableLinker interBbVariableLinker = new InterBbVariableLinker(intraBbVariableLinker, hashMap, bl, bl2);
        interBbVariableLinker.visit(function, null);
    }

    public InterBbVariableLinker(IntraBbVariableLinker intraBbVariableLinker, HashMap<BasicBlock, BasicBlock> hashMap, boolean bl, boolean bl2) {
        this.link = intraBbVariableLinker;
        this.idom = hashMap;
        this.linkUnlinked = bl;
        this.linkKilled = bl2;
    }

    @Override
    protected void visitPrgFunction(PrgFunction prgFunction, BasicBlock basicBlock) {
        assert (this.func == null);
        this.func = prgFunction;
        super.visitPrgFunction(prgFunction, basicBlock);
        assert (this.func == prgFunction);
        this.func = null;
    }

    @Override
    protected void visitBasicBlock(BasicBlock basicBlock, BasicBlock basicBlock2) {
        assert (basicBlock2 == null);
        super.visitBasicBlock(basicBlock, basicBlock);
        this.visitFollowingPhi(basicBlock);
    }

    @Override
    protected void visitPhiStmt(PhiStmt phiStmt, BasicBlock basicBlock) {
    }

    private void visitFollowingPhi(BasicBlock basicBlock) {
        for (BbEdge bbEdge : basicBlock.getOutlist()) {
            Collection<PhiStmt> collection = ((BasicBlock)bbEdge.getDst()).getPhis();
            for (PhiStmt phiStmt : collection) {
                Expression expression = phiStmt.getOption().get(basicBlock.getId());
                assert (expression != null);
                expression = this.visitExpression(expression, basicBlock);
                phiStmt.getOption().put(basicBlock.getId(), expression);
            }
        }
    }

    @Override
    protected Expression visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, BasicBlock basicBlock) {
        if (this.linkUnlinked) {
            Expression expression = this.getVariable(this.idom.get(basicBlock), variableRefUnlinked.getName());
            assert (expression != null);
            return expression;
        }
        return super.visitVariableRefUnlinked(variableRefUnlinked, basicBlock);
    }

    @Override
    protected Expression visitVariableKilled(VariableKilled variableKilled, BasicBlock basicBlock) {
        if (this.linkKilled) {
            Expression expression = this.getVariable(this.idom.get(basicBlock), variableKilled.getName());
            assert (expression != null);
            return expression;
        }
        return super.visitVariableKilled(variableKilled, basicBlock);
    }

    private Expression getVariable(BasicBlock basicBlock, VariableName variableName) {
        BasicBlock basicBlock2 = basicBlock;
        while (basicBlock2 != null) {
            Expression expression = this.link.getVariable(basicBlock2, variableName);
            if (expression != null) {
                return expression;
            }
            basicBlock2 = this.idom.get(basicBlock2);
        }
        return new VariableRefUnlinked(variableName);
    }
}

