/*
 * Decompiled with CFR 0.152.
 */
package cfg.linker;

import cfg.IrReplaceExprTraverser;
import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.Expression;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.PrgFunction;
import cfg.linker.RegSymTable;
import cfg.linker.SymTable;
import cfg.statement.PhiStmt;
import cfg.variable.SsaVariable;
import cfg.variable.VariableName;
import java.util.Collection;
import java.util.HashMap;
import knowledge.KnowKilledByFunction;
import knowledge.KnowledgeBase;

public class IntraBbVariableLinker
extends IrReplaceExprTraverser<Void> {
    private HashMap<BasicBlock, RegSymTable> sym = new HashMap();
    private BasicBlock bb = null;
    private KnowledgeBase kb;
    private boolean linkUnlinked;
    private boolean linkKilled;

    public static void process(PrgFunction prgFunction, KnowledgeBase knowledgeBase, boolean bl, boolean bl2) {
        IntraBbVariableLinker intraBbVariableLinker = new IntraBbVariableLinker(knowledgeBase, bl, bl2);
        intraBbVariableLinker.visit(prgFunction, null);
    }

    public IntraBbVariableLinker(KnowledgeBase knowledgeBase, boolean bl, boolean bl2) {
        this.kb = knowledgeBase;
        this.linkUnlinked = bl;
        this.linkKilled = bl2;
        assert (bl || bl2);
    }

    public Expression getVariable(BasicBlock basicBlock, VariableName variableName) {
        if (this.sym.get(basicBlock).hasDefinition(variableName)) {
            return this.sym.get(basicBlock).getAsExpr(variableName);
        }
        return null;
    }

    @Override
    protected void visitPhiStmt(PhiStmt phiStmt, Void void_) {
        this.visit(phiStmt.getVarname(), void_);
    }

    @Override
    protected void visitBasicBlock(BasicBlock basicBlock, Void void_) {
        assert (this.bb == null);
        this.sym.put(basicBlock, new RegSymTable());
        this.bb = basicBlock;
        super.visitBasicBlock(basicBlock, void_);
        this.visitFollowingPhi(basicBlock);
        this.bb = null;
    }

    private void visitFollowingPhi(BasicBlock basicBlock) {
        for (BbEdge bbEdge : basicBlock.getOutlist()) {
            Collection<PhiStmt> collection = ((BasicBlock)bbEdge.getDst()).getPhis();
            for (PhiStmt phiStmt : collection) {
                Expression expression = phiStmt.getOption().get(basicBlock.getId());
                assert (expression != null);
                expression = this.visitExpression(expression, null);
                phiStmt.getOption().put(basicBlock.getId(), expression);
            }
        }
    }

    @Override
    protected void visitSsaVariable(SsaVariable ssaVariable, Void void_) {
        this.sym.get(this.bb).def(ssaVariable.getName(), ssaVariable);
        super.visitSsaVariable(ssaVariable, void_);
    }

    @Override
    protected Expression visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, Void void_) {
        if (this.linkUnlinked) {
            SymTable symTable = this.sym.get(this.bb);
            if (symTable.hasDefinition(variableRefUnlinked.getName())) {
                return symTable.getAsExpr(variableRefUnlinked.getName());
            }
            return super.visitVariableRefUnlinked(variableRefUnlinked, void_);
        }
        return super.visitVariableRefUnlinked(variableRefUnlinked, void_);
    }

    @Override
    protected Expression visitVariableKilled(VariableKilled variableKilled, Void void_) {
        if (this.linkKilled) {
            SymTable symTable = this.sym.get(this.bb);
            if (symTable.hasDefinition(variableKilled.getName())) {
                return symTable.getAsExpr(variableKilled.getName());
            }
            return super.visitVariableKilled(variableKilled, void_);
        }
        return super.visitVariableKilled(variableKilled, void_);
    }

    @Override
    protected Expression visitCallExprLinked(CallExprLinked callExprLinked, Void void_) {
        Expression expression = super.visitCallExprLinked(callExprLinked, void_);
        KnowKilledByFunction knowKilledByFunction = (KnowKilledByFunction)this.kb.getEntry(KnowKilledByFunction.class);
        SymTable symTable = this.sym.get(this.bb);
        Function function = callExprLinked.getFunc();
        symTable.killAll(knowKilledByFunction.getKilled(function), function);
        return expression;
    }

    @Override
    protected Expression visitCallExprUnlinked(CallExprUnlinked callExprUnlinked, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected Expression visitCallExprPointer(CallExprPointer callExprPointer, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }
}

