/*
 * Decompiled with CFR 0.152.
 */
package cfg.linker;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.Function;
import cfg.linker.DefUseKillVisitor;
import cfg.variable.SsaVariable;
import cfg.variable.VarComp;
import cfg.variable.VariableName;
import graph.DominanceFrontier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PhiInserter {
    private List<VariableName> globals = new ArrayList<VariableName>();
    private Function func;
    private DominanceFrontier<BasicBlock, BbEdge> df;

    public PhiInserter(Function function, DominanceFrontier<BasicBlock, BbEdge> dominanceFrontier) {
        this.df = dominanceFrontier;
        this.func = function;
    }

    public void doWork() {
        DefUseKillVisitor defUseKillVisitor = new DefUseKillVisitor();
        defUseKillVisitor.visit(this.func, null);
        for (HashSet<VariableName> object : defUseKillVisitor.getUse().values()) {
            this.globals.addAll(object);
        }
        Collections.sort(this.globals, new VarComp());
        int n = 0;
        for (VariableName variableName : this.globals) {
            Set set = defUseKillVisitor.getBlocks().get(variableName);
            LinkedList<BasicBlock> linkedList = new LinkedList<BasicBlock>(set);
            for (int i = 0; i < linkedList.size(); ++i) {
                BasicBlock basicBlock = (BasicBlock)linkedList.get(i);
                for (BasicBlock basicBlock2 : this.df.getDf().get(basicBlock)) {
                    if (basicBlock2.hasPhiFor(variableName)) continue;
                    basicBlock2.insertPhi(new SsaVariable(variableName, --n));
                    if (linkedList.contains(basicBlock2)) continue;
                    linkedList.add(basicBlock2);
                }
            }
        }
    }
}

