/*
 * Decompiled with CFR 0.152.
 */
package cfg.linker;

import cfg.IntConstant;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableKilled;
import cfg.expression.VariableRefLinked;
import cfg.function.Function;
import cfg.variable.Variable;
import cfg.variable.VariableName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SymTable {
    private Map<VariableName, Alias> alias = new HashMap<VariableName, Alias>();
    private Map<VariableName, Variable> def = new HashMap<VariableName, Variable>();
    private Map<VariableName, Variable> dirty = new HashMap<VariableName, Variable>();
    private Map<VariableName, Function> killed = new HashMap<VariableName, Function>();

    public void addAlias(VariableName variableName, VariableName variableName2, VariableName variableName3, VariableName variableName4) {
        assert (!this.alias.containsKey(variableName));
        assert (!this.alias.containsKey(variableName2));
        assert (!this.alias.containsKey(variableName3));
        assert (!this.alias.containsKey(variableName4));
        Alias alias = new Alias(variableName, variableName2, variableName3, variableName4);
        this.alias.put(variableName, alias);
        this.alias.put(variableName2, alias);
        this.alias.put(variableName3, alias);
        this.alias.put(variableName4, alias);
    }

    public void addAlias(VariableName variableName, VariableName variableName2) {
        assert (!this.alias.containsKey(variableName));
        assert (!this.alias.containsKey(variableName2));
        Alias alias = new Alias(variableName, variableName2, null, null);
        this.alias.put(variableName, alias);
        this.alias.put(variableName2, alias);
    }

    public Expression getAsExpr(VariableName variableName) {
        assert (this.hasDefinition(variableName));
        this.checkInvariant();
        if (this.killed.containsKey(variableName)) {
            return new VariableKilled(variableName, this.killed.get(variableName));
        }
        if (this.def.containsKey(variableName)) {
            Variable variable = this.def.get(variableName);
            VariableRefLinked variableRefLinked = this.createRefTo(variable);
            return variableRefLinked;
        }
        if (this.dirty.containsKey(variableName)) {
            return this.reconstructDirty(variableName);
        }
        return this.reconstructFromBigger(variableName);
    }

    private Expression reconstructFromBigger(VariableName variableName) {
        Expression expression;
        Alias alias = this.alias.get(variableName);
        if (alias == null) {
            return null;
        }
        int n = alias.getSize(variableName);
        int n2 = alias.getOffset(variableName);
        switch (n) {
            case 1: {
                if (this.def.containsKey(alias.word)) {
                    expression = this.getAsExpr(alias.word);
                    break;
                }
            }
            case 2: {
                if (this.def.containsKey(alias.dword)) {
                    expression = this.getAsExpr(alias.dword);
                    break;
                }
            }
            default: {
                throw new RuntimeException("Can not reconstruct from bigger type for size " + n);
            }
        }
        expression = new IntegerExpr(expression, new IntConstant((1 << n * 8) - 1), IntegerOp.And);
        if (n2 > 0) {
            expression = new IntegerExpr(expression, new IntConstant(8 * n2), IntegerOp.ShiftRight);
        }
        return expression;
    }

    private Expression reconstructDirty(VariableName variableName) {
        IntegerExpr integerExpr;
        this.checkInvariant();
        assert (this.dirty.containsKey(variableName));
        Alias alias = this.alias.get(variableName);
        int n = alias.getSize(variableName);
        switch (n) {
            case 4: {
                VariableRefLinked variableRefLinked = this.createRefTo(this.dirty.get(variableName));
                VariableName variableName2 = this.getDefined(alias);
                if (alias.getSize(variableName2) == 2) {
                    integerExpr = new IntegerExpr(variableRefLinked, new IntConstant(-65536L), IntegerOp.And);
                    integerExpr = new IntegerExpr(integerExpr, this.getAsExpr(variableName2), IntegerOp.Or);
                    break;
                }
                assert (alias.getSize(variableName2) == 1);
                if (alias.getOffset(variableName2) == 0) {
                    integerExpr = new IntegerExpr(variableRefLinked, new IntConstant(-256L), IntegerOp.And);
                    integerExpr = new IntegerExpr(integerExpr, this.getAsExpr(variableName2), IntegerOp.Or);
                    break;
                }
                integerExpr = new IntegerExpr(variableRefLinked, new IntConstant(-65281L), IntegerOp.And);
                integerExpr = new IntegerExpr(integerExpr, new IntegerExpr(this.getAsExpr(variableName2), new IntConstant(8L), IntegerOp.ShiftLeft), IntegerOp.Or);
                break;
            }
            case 2: {
                if (this.def.containsKey(alias.lowByte) && this.def.containsKey(alias.highByte)) {
                    VariableRefLinked variableRefLinked = this.createRefTo(this.def.get(alias.lowByte));
                    VariableRefLinked variableRefLinked2 = this.createRefTo(this.def.get(alias.highByte));
                    integerExpr = new IntegerExpr(variableRefLinked2, new IntConstant(8L), IntegerOp.ShiftLeft);
                    integerExpr = new IntegerExpr(integerExpr, variableRefLinked, IntegerOp.Or);
                    break;
                }
                if (this.def.containsKey(alias.lowByte)) {
                    VariableRefLinked variableRefLinked = this.createRefTo(this.dirty.get(variableName));
                    VariableRefLinked variableRefLinked3 = this.createRefTo(this.def.get(alias.lowByte));
                    integerExpr = new IntegerExpr(variableRefLinked, new IntConstant(65280L), IntegerOp.And);
                    integerExpr = new IntegerExpr(variableRefLinked3, integerExpr, IntegerOp.Or);
                    break;
                }
                if (this.def.containsKey(alias.highByte)) {
                    VariableRefLinked variableRefLinked = this.createRefTo(this.dirty.get(variableName));
                    VariableRefLinked variableRefLinked4 = this.createRefTo(this.def.get(alias.highByte));
                    integerExpr = new IntegerExpr(variableRefLinked4, new IntConstant(8L), IntegerOp.ShiftLeft);
                    integerExpr = new IntegerExpr(integerExpr, new IntegerExpr(variableRefLinked, new IntConstant(255L), IntegerOp.And), IntegerOp.Or);
                    break;
                }
                throw new RuntimeException("Unexpected case");
            }
            default: {
                throw new RuntimeException("Unsupported size: " + n);
            }
        }
        return integerExpr;
    }

    private VariableName getDefined(Alias alias) {
        if (this.def.containsKey(alias.lowByte) && this.def.containsKey(alias.highByte)) {
            return alias.word;
        }
        if (this.def.containsKey(alias.lowByte)) {
            return alias.lowByte;
        }
        if (this.def.containsKey(alias.highByte)) {
            return alias.highByte;
        }
        if (this.def.containsKey(alias.word)) {
            return alias.word;
        }
        if (this.def.containsKey(alias.dword)) {
            return alias.dword;
        }
        throw new RuntimeException("Nothing defined for " + alias.dword);
    }

    private VariableRefLinked createRefTo(Variable variable) {
        VariableRefLinked variableRefLinked = new VariableRefLinked(variable);
        return variableRefLinked;
    }

    public void def(VariableName variableName, Variable variable) {
        this.checkInvariant();
        Alias alias = this.alias.get(variableName);
        if (alias != null) {
            int n = alias.getSize(variableName);
            switch (n) {
                case 1: {
                    this.makeDirty(alias.word);
                    this.makeDirty(alias.dword);
                    break;
                }
                case 2: {
                    this.killedByBigger(alias.lowByte);
                    this.killedByBigger(alias.highByte);
                    this.makeDirty(alias.dword);
                    break;
                }
                case 4: {
                    this.killedByBigger(alias.lowByte);
                    this.killedByBigger(alias.highByte);
                    this.killedByBigger(alias.word);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type size: " + n);
                }
            }
        }
        this.killed.remove(variableName);
        this.dirty.remove(variableName);
        this.def.put(variableName, variable);
        this.checkInvariant();
    }

    private void killedByBigger(VariableName variableName) {
        this.def.remove(variableName);
        this.dirty.remove(variableName);
        this.checkInvariant(variableName);
    }

    private void makeDirty(VariableName variableName) {
        if (this.def.containsKey(variableName)) {
            this.dirty.put(variableName, this.def.get(variableName));
            this.def.remove(variableName);
        }
        this.checkInvariant(variableName);
    }

    public void kill(VariableName variableName, Function function) {
        Alias alias = this.alias.get(variableName);
        if (alias != null) {
            this.dirty.remove(alias.dword);
            this.def.remove(alias.dword);
            this.killed.put(alias.dword, function);
            this.dirty.remove(alias.word);
            this.def.remove(alias.word);
            this.killed.put(alias.word, function);
            this.dirty.remove(alias.highByte);
            this.def.remove(alias.highByte);
            this.killed.put(alias.highByte, function);
            this.dirty.remove(alias.lowByte);
            this.def.remove(alias.lowByte);
            this.killed.put(alias.lowByte, function);
        } else {
            this.dirty.remove(variableName);
            this.def.remove(variableName);
            this.killed.put(variableName, function);
        }
        this.checkInvariant(variableName);
    }

    public void killAll(Collection<? extends VariableName> collection, Function function) {
        this.checkInvariant();
        for (VariableName variableName : collection) {
            this.kill(variableName, function);
        }
        this.checkInvariant();
    }

    public boolean hasDefinition(VariableName variableName) {
        this.checkInvariant();
        if (this.killed.containsKey(variableName)) {
            return true;
        }
        if (this.dirty.containsKey(variableName) || this.def.containsKey(variableName)) {
            return true;
        }
        Alias alias = this.alias.get(variableName);
        if (alias != null) {
            int n = alias.getSize(variableName);
            if (n <= 4 && (this.dirty.containsKey(alias.dword) || this.def.containsKey(alias.dword))) {
                return true;
            }
            if (n <= 2 && (this.dirty.containsKey(alias.word) || this.def.containsKey(alias.word))) {
                return true;
            }
            if (n == 2 && this.def.containsKey(alias.lowByte) && this.def.containsKey(alias.highByte)) {
                return true;
            }
        }
        return false;
    }

    private void checkInvariant() {
        HashSet<VariableName> hashSet = new HashSet<VariableName>();
        hashSet.addAll(this.def.keySet());
        hashSet.addAll(this.dirty.keySet());
        hashSet.addAll(this.killed.keySet());
        for (VariableName variableName : hashSet) {
            Alias alias = this.alias.get(variableName);
            if (alias != null) {
                this.checkInvariant(alias);
                continue;
            }
            this.checkInvariant(variableName);
        }
    }

    private void checkInvariant(Alias alias) {
        this.checkInvariant(alias.lowByte);
        this.checkInvariant(alias.highByte);
        this.checkInvariant(alias.word);
        this.checkInvariant(alias.dword);
        int n = 0;
        if (this.def.containsKey(alias.lowByte)) {
            ++n;
        }
        if (this.def.containsKey(alias.highByte)) {
            ++n;
        }
        if (this.def.containsKey(alias.word)) {
            ++n;
        }
        if (this.def.containsKey(alias.dword)) {
            ++n;
        }
        if (n > 1) {
            throw new RuntimeException("Invariant 2 does not hold for: " + alias.dword);
        }
    }

    private void checkInvariant(VariableName variableName) {
        int n = 0;
        if (this.def.containsKey(variableName)) {
            ++n;
        }
        if (this.dirty.containsKey(variableName)) {
            ++n;
        }
        if (this.killed.containsKey(variableName)) {
            ++n;
        }
        if (n > 1) {
            throw new RuntimeException("Invariant 1 does not hold for: " + variableName);
        }
    }

    private class Alias {
        VariableName lowByte;
        VariableName highByte;
        VariableName word;
        VariableName dword;

        public Alias(VariableName variableName, VariableName variableName2, VariableName variableName3, VariableName variableName4) {
            this.dword = variableName;
            this.word = variableName2;
            this.highByte = variableName3;
            this.lowByte = variableName4;
        }

        public int getOffset(VariableName variableName) {
            if (variableName == this.lowByte) {
                return 0;
            }
            if (variableName == this.highByte) {
                return 1;
            }
            if (variableName == this.word) {
                return 0;
            }
            if (variableName == this.dword) {
                return 0;
            }
            throw new RuntimeException("Not an element of this set");
        }

        public int getSize(VariableName variableName) {
            if (variableName == this.lowByte) {
                return 1;
            }
            if (variableName == this.highByte) {
                return 1;
            }
            if (variableName == this.word) {
                return 2;
            }
            if (variableName == this.dword) {
                return 4;
            }
            throw new RuntimeException("Not an element of this set");
        }
    }
}

