/*
 * Decompiled with CFR 0.152.
 */
package cfg.matcher;

import cfg.IntConstant;
import cfg.IrItr;
import cfg.IrType;
import cfg.expression.CallExprLinked;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRef;
import cfg.function.Function;
import cfg.variable.Variable;
import cfg.variable.VariableName;

public abstract class Matcher {
    protected IrItr stream;
    private String error;

    public String getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    protected void wrongToken(IrType irType) {
        this.error = "Wrong token: " + (Object)((Object)this.stream.peek().getIrType()) + ", expected: " + (Object)((Object)irType);
    }

    protected void doError(String string, Object object) {
        this.error = string + ": " + this.stream.peek() + ", expeted: " + object;
    }

    protected void checkForEnd() {
        if (!this.hasError() && this.stream.hasNext()) {
            this.error = "Expected end of stream but found: " + this.stream.peek();
        }
    }

    public void parse(IrItr irItr) {
        this.stream = irItr;
        this.error = null;
        this.doParse();
        this.stream = null;
    }

    protected abstract void doParse();

    protected boolean parseFuncRefLinked(Function function) {
        if (this.stream.peek().getIrType() == IrType.CallExprLinked && ((CallExprLinked)this.stream.peek()).getFunc() == function) {
            this.stream.next();
            return true;
        }
        return false;
    }

    protected VariableName parseVarDef() {
        if (this.stream.peek().getIrType() == IrType.Variable) {
            return ((Variable)this.stream.next()).getName();
        }
        this.wrongToken(IrType.Variable);
        return null;
    }

    protected VariableName parseVarRef() {
        switch (this.stream.peek().getIrType()) {
            case VariableRefKilled: 
            case VariableRefLinked: 
            case VariableRefUnlinked: {
                return ((VariableRef)this.stream.next()).getName();
            }
        }
        this.wrongToken(IrType.VariableRefUnlinked);
        return null;
    }

    protected long parseIntConstant() {
        if (this.stream.peek().getIrType() == IrType.IntConstant) {
            return ((IntConstant)this.stream.next()).getValue();
        }
        this.wrongToken(IrType.IntConstant);
        return 0L;
    }

    protected IntegerOp parseIntegerExpr() {
        if (this.stream.peek().getIrType() == IrType.IntegerExpr) {
            return ((IntegerExpr)this.stream.next()).getOp();
        }
        this.wrongToken(IrType.IntegerExpr);
        return null;
    }

    protected int removeTokens(IrType irType) {
        int n = 0;
        while (this.stream.peek().getIrType() == irType) {
            this.stream.next();
            ++n;
        }
        return n;
    }

    protected boolean removeToken(IrType irType) {
        if (this.stream.peek().getIrType() != irType) {
            this.wrongToken(irType);
            return false;
        }
        this.stream.next();
        return true;
    }

    protected void skipExpr() {
        switch (this.stream.peek().getIrType()) {
            case VariableRefKilled: 
            case VariableRefLinked: 
            case VariableRefUnlinked: {
                this.stream.next();
                break;
            }
            default: {
                throw new RuntimeException("Unknown expression: " + (Object)((Object)this.stream.peek().getIrType()));
            }
        }
    }
}

