/*
 * Decompiled with CFR 0.152.
 */
package cfg.matcher;

import cfg.IrType;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRefLinked;
import cfg.matcher.Matcher;
import cfg.variable.Variable;

public class VarAndOffsetMatcher
extends Matcher {
    private Variable var;
    private long offset;

    public Variable getVar() {
        return this.var;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    protected void doParse() {
        switch (this.stream.peek().getIrType()) {
            case IntegerExpr: {
                this.parseIntExpr();
                this.checkForEnd();
                break;
            }
            default: {
                this.wrongToken(IrType.IntegerExpr);
            }
        }
    }

    private void parseIntExpr() {
        IntegerOp integerOp = ((IntegerExpr)this.stream.next()).getOp();
        switch (this.stream.peek().getIrType()) {
            case VariableRefLinked: {
                this.var = ((VariableRefLinked)this.stream.next()).getReference();
                break;
            }
            default: {
                this.wrongToken(IrType.VariableRefLinked);
            }
        }
        this.offset = this.parseIntConstant();
        switch (integerOp) {
            case Add: {
                break;
            }
            case Sub: {
                this.offset = -this.offset;
                break;
            }
            default: {
                this.doError("Expected add or sub operand", (Object)integerOp);
            }
        }
    }
}

