/*
 * Decompiled with CFR 0.152.
 */
package cfg.matcher;

import cfg.IrType;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.matcher.Matcher;
import cfg.variable.VariableName;

public class VarnameIntOpChangeMatcher
extends Matcher {
    private VariableName var;
    private IntegerOp op;
    private long value;

    public VarnameIntOpChangeMatcher(VariableName variableName) {
        this.var = variableName;
    }

    public IntegerOp getOp() {
        return this.op;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    protected void doParse() {
        switch (this.stream.peek().getIrType()) {
            case AssignmentStmt: {
                this.parseAssignment();
                this.checkForEnd();
                break;
            }
            default: {
                this.wrongToken(IrType.AssignmentStmt);
            }
        }
    }

    private void parseAssignment() {
        this.stream.next();
        boolean bl = false;
        while (this.stream.peek().getIrType() == IrType.Variable) {
            if (this.parseVarDef() != this.var) continue;
            bl = true;
        }
        if (!bl) {
            this.doError("Expected different variable (1)", null);
            return;
        }
        switch (this.stream.peek().getIrType()) {
            case IntegerExpr: {
                this.parseIntExpr();
                break;
            }
            default: {
                this.wrongToken(IrType.IntegerExpr);
            }
        }
    }

    private void parseIntExpr() {
        this.op = ((IntegerExpr)this.stream.next()).getOp();
        if (this.var != this.parseVarRef()) {
            this.doError("Expected different variable (2)", null);
            return;
        }
        this.value = this.parseIntConstant();
    }
}

