/*
 * Decompiled with CFR 0.152.
 */
package cfg.parser;

import cfg.IrItr;
import cfg.IrType;
import cfg.expression.IntegerOp;
import cfg.matcher.PopMatcher;
import cfg.matcher.VarnameIntOpChangeMatcher;
import cfg.parser.State;
import cfg.statement.Statement;
import cfg.variable.VariableName;
import disassembler.diStorm3.Registers;
import java.util.LinkedList;
import java.util.List;

public class EpilogParser {
    private LinkedList<VariableName> stack = new LinkedList();
    private long stacksize = 0L;
    private State state;

    public EpilogParser(List<Statement> list, List<VariableName> list2, long l) {
        this.stack = new LinkedList<VariableName>(list2);
        this.stacksize = l;
        if (!this.findNextState()) {
            this.state = State.waitret;
        }
        this.parse(list);
    }

    public boolean isSuccess() {
        return this.state == State.success;
    }

    private boolean findNextState() {
        if (this.stacksize > 0L) {
            this.state = State.waitespdec;
            return true;
        }
        if (!this.stack.isEmpty()) {
            this.state = State.waitpop;
            return true;
        }
        return false;
    }

    private void parseSym(Statement statement) {
        switch (this.state) {
            case waitespdec: {
                if (!this.isEspDec(statement)) break;
                statement.setDeleted();
                if (this.findNextState()) break;
                this.state = State.expectret;
                break;
            }
            case waitpop: 
            case expectpop: {
                if (this.isPop(statement)) {
                    statement.setDeleted();
                    if (this.findNextState()) break;
                    this.state = State.expectret;
                    break;
                }
                if (this.state != State.expectpop) break;
                this.state = State.fail;
                break;
            }
            case waitret: 
            case expectret: {
                if (this.isRet(statement)) {
                    this.state = State.success;
                    break;
                }
                if (this.state != State.expectret) break;
                this.state = State.fail;
                break;
            }
            case fail: {
                break;
            }
            case success: {
                this.state = State.fail;
                break;
            }
            default: {
                throw new RuntimeException("Unknown state: " + (Object)((Object)this.state));
            }
        }
    }

    private boolean isRet(Statement statement) {
        return statement.getIrType() == IrType.RetStmt;
    }

    private boolean isPop(Statement statement) {
        PopMatcher popMatcher = new PopMatcher();
        popMatcher.parse(new IrItr(statement));
        if (popMatcher.hasError()) {
            return false;
        }
        if (popMatcher.getVariable() != this.stack.peek()) {
            throw new RuntimeException("Stack problem, got " + popMatcher.getVariable() + " expected " + this.stack.peek());
        }
        this.stack.pop();
        return true;
    }

    private boolean isEspDec(Statement statement) {
        VarnameIntOpChangeMatcher varnameIntOpChangeMatcher = new VarnameIntOpChangeMatcher(Registers.ESP);
        varnameIntOpChangeMatcher.parse(new IrItr(statement));
        if (varnameIntOpChangeMatcher.hasError()) {
            return false;
        }
        if (varnameIntOpChangeMatcher.getOp() != IntegerOp.Add || varnameIntOpChangeMatcher.getValue() != this.stacksize) {
            return false;
        }
        this.stacksize = 0L;
        return true;
    }

    private void parse(List<Statement> list) {
        for (int i = 0; i < list.size(); ++i) {
            Statement statement = list.get(i);
            this.parseSym(statement);
        }
    }
}

