/*
 * Decompiled with CFR 0.152.
 */
package cfg.parser;

import cfg.Application;
import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.expression.CallExpr;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprUnlinked;
import cfg.function.LibFunction;
import cfg.parser.OpParserImpl;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.Statement;
import cfg.variable.VariableName;
import disassembler.diStorm3.DecomposedInst;
import disassembler.diStorm3.OpcodeEnum;
import disassembler.diStorm3.Registers;
import elfreader.ElfReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import util.NumPrint;
import util.SymbolIndexStream;

public class FunctionFactory {
    private Queue<Long> queue = new LinkedList<Long>();
    private HashMap<Long, BasicBlock> bbs = new HashMap();
    private ArrayList<DecomposedInst> instructions;
    private Set<Long> funcAddr = new HashSet<Long>();
    private int number = 0;
    private ElfReader elfReader;
    private VariableName retvar;
    private Application app;

    public FunctionFactory(long l, boolean bl, ArrayList<DecomposedInst> arrayList, ElfReader elfReader, Application application) {
        this.queue.add(l);
        this.app = application;
        this.instructions = arrayList;
        this.elfReader = elfReader;
        this.elfReader = elfReader;
        this.retvar = bl ? Registers.EAX : null;
    }

    private boolean isAddrInRange(long l) {
        return l >= this.instructions.get(0).getAddress() && l <= this.instructions.get(this.instructions.size() - 1).getAddress();
    }

    public void process() {
        while (!this.queue.isEmpty()) {
            long l = this.queue.peek();
            this.parseBb(l);
            this.queue.remove(l);
        }
    }

    public Set<Long> getFuncAddr() {
        return this.funcAddr;
    }

    public Collection<BasicBlock> getBbs() {
        return this.bbs.values();
    }

    private void parseBb(long l) {
        if (this.isInParsedBbs(l)) {
            return;
        }
        int n = this.getIndexOf(l);
        BasicBlock basicBlock = new BasicBlock(l);
        OpParserImpl opParserImpl = new OpParserImpl(this.number, new SymbolIndexStream<DecomposedInst>(this.instructions, n), this.elfReader, this.retvar, this.app);
        opParserImpl.parse();
        while (opParserImpl.hasMore()) {
            long l2;
            Object object;
            Statement statement = opParserImpl.consume();
            basicBlock.addCode(statement);
            OpcodeEnum opcodeEnum = statement.getOriginal().getOpcode();
            if (opcodeEnum.isEndOfBb()) {
                if (opcodeEnum.isJump()) {
                    JumpStmt jumpStmt = (JumpStmt)statement;
                    object = jumpStmt.getJmpDst().iterator();
                    while (object.hasNext()) {
                        long l3 = object.next();
                        this.addBb(l3);
                    }
                }
                if (opcodeEnum.isConditionalJump()) {
                    this.addBb(opParserImpl.peek().getOriginal().getAddress());
                }
                this.bbs.put(l, basicBlock);
                this.number = opParserImpl.getNumber();
                return;
            }
            if (opcodeEnum.isCall()) {
                CallExpr callExpr = (CallExpr)((AssignmentStmt)statement).getSource();
                switch (callExpr.getIrType()) {
                    case CallExprUnlinked: {
                        this.funcAddr.add(((CallExprUnlinked)callExpr).getAddr());
                        break;
                    }
                    case CallExprPointer: {
                        break;
                    }
                    case CallExprLinked: {
                        object = ((CallExprLinked)callExpr).getFunc();
                        if (object.getIrType() != IrType.FuncLibrary || ((LibFunction)object).doesReturn()) break;
                        this.bbs.put(l, basicBlock);
                        this.number = opParserImpl.getNumber();
                        return;
                    }
                    default: {
                        throw new RuntimeException("Unknown call: " + (Object)((Object)callExpr.getIrType()));
                    }
                }
            }
            if (!opParserImpl.hasMore() || !this.bbs.containsKey(l2 = opParserImpl.peek().getOriginal().getAddress())) continue;
            basicBlock.addCode(new JumpStmt(l2));
            this.bbs.put(l, basicBlock);
            this.number = opParserImpl.getNumber();
            return;
        }
        throw new RuntimeException("premature end of instruction stream");
    }

    private void addBb(long l) {
        if (!this.isAddrInRange(l)) {
            return;
        }
        if (this.queue.contains(l)) {
            return;
        }
        if (!this.isInParsedBbs(l)) {
            this.queue.add(l);
        }
    }

    private boolean isInParsedBbs(long l) {
        for (BasicBlock basicBlock : this.bbs.values()) {
            if (l < basicBlock.getFirstAddr() || l > basicBlock.getLastAddr()) continue;
            BasicBlock basicBlock2 = BasicBlock.splitAtAddr(basicBlock, l);
            if (basicBlock2 != null) {
                this.bbs.put(l, basicBlock2);
            }
            return true;
        }
        return false;
    }

    private int getIndexOf(long l) {
        if (!this.isAddrInRange(l)) {
            throw new RuntimeException("Address out of bounds: " + NumPrint.toString(l));
        }
        int n = 0;
        int n2 = this.instructions.size() - 1;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            if (l < this.instructions.get(n3).getAddress()) {
                n2 = n3;
                continue;
            }
            if (l > this.instructions.get(n3).getAddress()) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        throw new RuntimeException("Address not found in instructions");
    }
}

