/*
 * Decompiled with CFR 0.152.
 */
package cfg.parser;

import cfg.Application;
import cfg.IrItr;
import cfg.basicblock.BasicBlock;
import cfg.function.PrgFunction;
import cfg.matcher.NoretCallMatcher;
import cfg.parser.EpilogParser;
import cfg.parser.FunctionFactory;
import cfg.parser.PrologParser;
import cfg.variable.VariableName;
import disassembler.diStorm3.DecomposedInst;
import disassembler.diStorm3.Registers;
import elfreader.ElfReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public class IntermediateFactory {
    private Queue<Long> queue = new LinkedList<Long>();
    private HashMap<Long, PrgFunction> functions = new HashMap();
    private ArrayList<DecomposedInst> instructions;
    private ElfReader elfReader;
    private long mainfunc;
    private Application app;

    public IntermediateFactory(long l, ArrayList<DecomposedInst> arrayList, ElfReader elfReader, Application application) {
        this.queue.add(l);
        this.app = application;
        this.instructions = arrayList;
        this.elfReader = elfReader;
        this.mainfunc = l;
    }

    public void process() {
        while (!this.queue.isEmpty()) {
            long l = this.queue.peek();
            PrgFunction prgFunction = this.parseFunction(l);
            if (prgFunction != null) {
                this.functions.put(l, prgFunction);
            }
            this.queue.remove(l);
        }
        this.app.setFunctions(new ArrayList<PrgFunction>(this.functions.values()), this.functions.get(this.mainfunc));
    }

    private boolean isAddrInRange(long l) {
        return l >= this.instructions.get(0).getAddress() && l <= this.instructions.get(this.instructions.size() - 1).getAddress();
    }

    private PrgFunction parseFunction(long l) {
        if (this.isAddrInRange(l)) {
            FunctionFactory functionFactory = new FunctionFactory(l, l == this.mainfunc, this.instructions, this.elfReader, this.app);
            functionFactory.process();
            PrgFunction prgFunction = new PrgFunction(l, functionFactory.getBbs());
            PrologParser prologParser = new PrologParser(prgFunction.getEntry().getCode());
            prgFunction.setPreserves(new LinkedList<VariableName>(prologParser.getStack()));
            prgFunction.getPreserves().add(Registers.ESP);
            for (BasicBlock basicBlock : prgFunction.getExit()) {
                EpilogParser epilogParser;
                NoretCallMatcher noretCallMatcher = new NoretCallMatcher();
                noretCallMatcher.parse(new IrItr(basicBlock.getCode().getLast()));
                if (!noretCallMatcher.hasError() && !noretCallMatcher.doesReturn() || (epilogParser = new EpilogParser(basicBlock.getCode(), prologParser.getStack(), prologParser.getStacksize())).isSuccess()) continue;
                throw new RuntimeException("Error by parsing epilog: " + basicBlock);
            }
            prgFunction.setStacksize((int)prologParser.getStacksize());
            prgFunction.setBackupSize(prologParser.getStack().size() * 4);
            prgFunction.setUseEbpAsStackAddressing(prologParser.useEbpAsStackAddressing());
            this.addFunctions(functionFactory.getFuncAddr());
            return prgFunction;
        }
        return null;
    }

    private void addFunctions(Set<Long> set) {
        for (long l : set) {
            if (this.queue.contains(l) || this.functions.containsKey(l)) continue;
            this.queue.add(l);
        }
    }
}

