/*
 * Decompiled with CFR 0.152.
 */
package cfg.parser;

import cfg.Application;
import cfg.Assignable;
import cfg.Condition;
import cfg.Flags;
import cfg.IntConstant;
import cfg.IrType;
import cfg.expression.CallExpr;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.Expression;
import cfg.expression.IfExpr;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.UnaryExpression;
import cfg.expression.UnaryOp;
import cfg.expression.VariableRef;
import cfg.expression.VariableRefUnlinked;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.function.system.SystemFunctions;
import cfg.parser.OperationParser;
import cfg.statement.AssignmentStmt;
import cfg.statement.JumpStmt;
import cfg.statement.NopStmt;
import cfg.statement.RetStmt;
import cfg.statement.Statement;
import cfg.variable.ArrayAccess;
import cfg.variable.GlobalVariable;
import cfg.variable.SsaVariable;
import cfg.variable.StackVariable;
import cfg.variable.Variable;
import cfg.variable.VariableName;
import cfg.variable.VariablePtrDeref;
import disassembler.diStorm3.DecomposedInst;
import disassembler.diStorm3.Operand;
import disassembler.diStorm3.Registers;
import elfreader.ElfReader;
import elfreader.ElfRelocationReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import util.SymbolStream;

public class OpParserImpl
extends OperationParser {
    private VariableName retvar;
    private Map<Long, String> libmap;
    protected Application app;

    public OpParserImpl(int n, SymbolStream<DecomposedInst> symbolStream, ElfReader elfReader, VariableName variableName, Application application) {
        super(n, symbolStream, elfReader);
        this.app = application;
        this.retvar = variableName;
        this.libmap = ElfRelocationReader.getFuncNames(elfReader);
    }

    private AssignmentStmt newAss(DecomposedInst decomposedInst, Expression expression) {
        Assignable assignable = decomposedInst.mOperands[0].getType() == Operand.OperandType.Reg ? new SsaVariable(Registers.getRegisterByIndex(decomposedInst.mOperands[0].getIndex()), this.getNumber()) : (Assignable)((Object)OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst));
        LinkedList<Assignable> linkedList = new LinkedList<Assignable>();
        linkedList.add(assignable);
        linkedList.addAll(this.createDefFlagVariables(decomposedInst.getOpcode()));
        return new AssignmentStmt(this.getNumber(), decomposedInst, linkedList, expression);
    }

    private CallExpr newCall(Function function) {
        return this.newCall(function, new LinkedList<Expression>());
    }

    private CallExpr newCall(Function function, Expression expression) {
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        linkedList.add(expression);
        return this.newCall(function, linkedList);
    }

    private CallExpr newCall(Function function, List<Expression> list) {
        CallExprLinked callExprLinked = new CallExprLinked(function);
        callExprLinked.setParam(list);
        return callExprLinked;
    }

    private NopStmt newNop(DecomposedInst decomposedInst) {
        return new NopStmt(this.getNumber(), decomposedInst);
    }

    @Override
    protected Statement parseTest(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        assert (this.createUsedFlagsVariables(decomposedInst.getOpcode()).size() == 0);
        IntegerExpr integerExpr = new IntegerExpr(OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst), OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst), IntegerOp.And);
        return new AssignmentStmt(this.getNumber(), decomposedInst, new LinkedList<Assignable>(this.createDefFlagVariables(decomposedInst.getOpcode())), integerExpr);
    }

    @Override
    protected Statement parseMov(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        return this.newAss(decomposedInst, OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst));
    }

    @Override
    protected Statement parseMovs(DecomposedInst decomposedInst) {
        if (decomposedInst.getSize() != 2) {
            throw new RuntimeException("Not yet implemented");
        }
        assert (decomposedInst.mOperands.length == 2);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        Expression expression2 = OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst);
        if (expression2.getIrType() != IrType.VariablePtrDeref || expression.getIrType() != IrType.VariablePtrDeref) {
            throw new RuntimeException("Not yet implemented");
        }
        VariablePtrDeref variablePtrDeref = (VariablePtrDeref)expression;
        VariablePtrDeref variablePtrDeref2 = (VariablePtrDeref)expression2;
        expression = variablePtrDeref.getExpression();
        expression2 = variablePtrDeref2.getExpression();
        IntegerExpr integerExpr = new IntegerExpr(new VariableRefUnlinked(Registers.ECX), new IntConstant(4L), IntegerOp.Mul);
        LinkedList<Assignable> linkedList = new LinkedList<Assignable>();
        linkedList.add(new SsaVariable(Registers.ECX, this.getNumber()));
        linkedList.add(new SsaVariable(Registers.EDI, this.getNumber()));
        linkedList.add(new SsaVariable(Registers.ESI, this.getNumber()));
        CallExprLinked callExprLinked = new CallExprLinked(SystemFunctions.funcMemcpy);
        callExprLinked.getParam().add(expression);
        callExprLinked.getParam().add(expression2);
        callExprLinked.getParam().add(integerExpr);
        callExprLinked.getParam().add(new VariableRefUnlinked(Flags.Direction));
        return new AssignmentStmt(this.getNumber(), decomposedInst, linkedList, callExprLinked);
    }

    @Override
    protected Statement parseMovsd(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        Expression expression2 = OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst);
        VariableRefUnlinked variableRefUnlinked = null;
        if (expression.getIrType() == IrType.VariableRefUnlinked) {
            variableRefUnlinked = (VariableRefUnlinked)expression;
        } else if (expression2.getIrType() == IrType.VariableRefUnlinked) {
            variableRefUnlinked = (VariableRefUnlinked)expression2;
        }
        assert (variableRefUnlinked != null);
        assert (((Registers)variableRefUnlinked.getName()).isMmx());
        return this.parseMov(decomposedInst);
    }

    @Override
    protected Statement parseCmovx(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        Expression expression = Condition.buildExpr(Condition.parse(decomposedInst.getOpcode()));
        IfExpr ifExpr = new IfExpr(expression, OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst), OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst));
        return this.newAss(decomposedInst, ifExpr);
    }

    @Override
    protected Statement parseMovsx(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        return this.newAss(decomposedInst, OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst));
    }

    @Override
    protected Statement parseMovzx(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        return this.newAss(decomposedInst, OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst));
    }

    @Override
    protected Statement parseLea(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst);
        if (expression instanceof VariablePtrDeref) {
            expression = ((VariablePtrDeref)expression).getExpression();
        } else if (expression instanceof ArrayAccess) {
            assert (false);
        } else if (expression instanceof StackVariable) {
            expression = new IntegerExpr(new VariableRefUnlinked(Registers.ESP), new IntConstant(((StackVariable)expression).getOffset()), IntegerOp.Add);
        } else if (expression instanceof GlobalVariable) {
            assert (((GlobalVariable)expression).getSegment() == Registers.DS);
            expression = new IntConstant(((GlobalVariable)expression).getAddress());
        } else {
            throw new RuntimeException("not yet implemented: " + expression + " (" + decomposedInst + ")");
        }
        return this.newAss(decomposedInst, expression);
    }

    @Override
    protected Statement parseCmp(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 2);
        IntegerExpr integerExpr = new IntegerExpr(OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst), OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst), IntegerOp.Sub);
        return new AssignmentStmt(this.getNumber(), decomposedInst, new LinkedList<Assignable>(this.createDefFlagVariables(decomposedInst.getOpcode())), integerExpr);
    }

    @Override
    protected Statement parsePush(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 1);
        return new AssignmentStmt(this.getNumber(), decomposedInst, new LinkedList<Assignable>(), this.newCall((Function)SystemFunctions.push, OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst)));
    }

    @Override
    protected Statement parsePop(DecomposedInst decomposedInst) {
        return this.newAss(decomposedInst, this.newCall(SystemFunctions.pop));
    }

    @Override
    protected Statement parseLeave(DecomposedInst decomposedInst) {
        return this.newNop(decomposedInst);
    }

    private Statement parseIntegerOperation(DecomposedInst decomposedInst, IntegerOp integerOp) {
        assert (decomposedInst.mOperands.length == 2);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        Expression expression2 = OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst);
        IntegerExpr integerExpr = new IntegerExpr(expression, expression2, integerOp);
        return this.newAss(decomposedInst, integerExpr);
    }

    private Statement parseIntegerOperationCarry(DecomposedInst decomposedInst, IntegerOp integerOp) {
        assert (decomposedInst.mOperands.length == 2);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        Expression expression2 = OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst);
        IntegerExpr integerExpr = new IntegerExpr(expression, expression2, integerOp);
        integerExpr = new IntegerExpr(integerExpr, new VariableRefUnlinked(Flags.Carry), integerOp);
        return this.newAss(decomposedInst, integerExpr);
    }

    @Override
    protected Statement parseNeg(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 1);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        UnaryExpression unaryExpression = new UnaryExpression(expression, UnaryOp.Neg);
        return this.newAss(decomposedInst, unaryExpression);
    }

    @Override
    protected Statement parseInc(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 1);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        IntegerExpr integerExpr = new IntegerExpr(expression, new IntConstant(1L), IntegerOp.Add);
        return this.newAss(decomposedInst, integerExpr);
    }

    @Override
    protected Statement parseDec(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 1);
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        IntegerExpr integerExpr = new IntegerExpr(expression, new IntConstant(1L), IntegerOp.Sub);
        return this.newAss(decomposedInst, integerExpr);
    }

    @Override
    protected Statement parseXmul(DecomposedInst decomposedInst) {
        switch (decomposedInst.mOperands.length) {
            case 1: {
                VariableRefUnlinked variableRefUnlinked = (VariableRefUnlinked)OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
                assert (variableRefUnlinked.getName() == Registers.EAX || variableRefUnlinked.getName() == Registers.EBP || variableRefUnlinked.getName() == Registers.EBX || variableRefUnlinked.getName() == Registers.ECX || variableRefUnlinked.getName() == Registers.EDI || variableRefUnlinked.getName() == Registers.EDX || variableRefUnlinked.getName() == Registers.ESI || variableRefUnlinked.getName() == Registers.ESP);
                IntegerExpr integerExpr = new IntegerExpr(new VariableRefUnlinked(Registers.EAX), variableRefUnlinked, IntegerOp.Mul);
                LinkedList<Assignable> linkedList = new LinkedList<Assignable>();
                linkedList.add(new SsaVariable(Registers.EDX, this.getNumber()));
                linkedList.add(new SsaVariable(Registers.EAX, this.getNumber()));
                linkedList.addAll(this.createDefFlagVariables(decomposedInst.getOpcode()));
                return new AssignmentStmt(this.getNumber(), decomposedInst, linkedList, integerExpr);
            }
            case 2: {
                IntegerExpr integerExpr = new IntegerExpr(OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst), OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst), IntegerOp.Mul);
                return this.newAss(decomposedInst, integerExpr);
            }
            case 3: {
                IntegerExpr integerExpr = new IntegerExpr(OpParserImpl.parseOperand(decomposedInst.mOperands[1], decomposedInst), OpParserImpl.parseOperand(decomposedInst.mOperands[2], decomposedInst), IntegerOp.Mul);
                return this.newAss(decomposedInst, integerExpr);
            }
        }
        throw new RuntimeException("not yet implmented: " + decomposedInst);
    }

    @Override
    protected Statement parseXdiv(DecomposedInst decomposedInst) {
        switch (decomposedInst.mOperands.length) {
            case 1: {
                VariableRefUnlinked variableRefUnlinked = (VariableRefUnlinked)OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
                assert (variableRefUnlinked.getName() == Registers.EAX || variableRefUnlinked.getName() == Registers.EBP || variableRefUnlinked.getName() == Registers.EBX || variableRefUnlinked.getName() == Registers.ECX || variableRefUnlinked.getName() == Registers.EDI || variableRefUnlinked.getName() == Registers.EDX || variableRefUnlinked.getName() == Registers.ESI || variableRefUnlinked.getName() == Registers.ESP);
                IntegerExpr integerExpr = new IntegerExpr(new VariableRefUnlinked(Registers.EAX), variableRefUnlinked, IntegerOp.Div);
                Collection<VariableRef> collection = this.createUsedFlagsVariables(decomposedInst.getOpcode());
                LinkedList<Assignable> linkedList = new LinkedList<Assignable>();
                linkedList.add(new SsaVariable(Registers.EDX, this.getNumber()));
                linkedList.add(new SsaVariable(Registers.EAX, this.getNumber()));
                linkedList.addAll(this.createDefFlagVariables(decomposedInst.getOpcode()));
                collection.add(new VariableRefUnlinked(Registers.EDX));
                return new AssignmentStmt(this.getNumber(), decomposedInst, linkedList, integerExpr);
            }
        }
        throw new RuntimeException("not yet implmented: " + decomposedInst);
    }

    @Override
    protected Statement parseCdq(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 0);
        LinkedList<Assignable> linkedList = new LinkedList<Assignable>();
        linkedList.add(new SsaVariable(Registers.EDX, this.getNumber()));
        linkedList.add(new SsaVariable(Registers.EAX, this.getNumber()));
        return new AssignmentStmt(this.getNumber(), decomposedInst, linkedList, this.newCall((Function)SystemFunctions.castInt64, new VariableRefUnlinked(Registers.EAX)));
    }

    @Override
    protected Statement parseOr(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.Or);
    }

    @Override
    protected Statement parseAnd(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.And);
    }

    @Override
    protected Statement parseAdd(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.Add);
    }

    @Override
    protected Statement parseAdc(DecomposedInst decomposedInst) {
        return this.parseIntegerOperationCarry(decomposedInst, IntegerOp.Add);
    }

    @Override
    protected Statement parseXor(DecomposedInst decomposedInst) {
        if (decomposedInst.mOperands[0].equals(decomposedInst.mOperands[1])) {
            return this.newAss(decomposedInst, new IntConstant(0L));
        }
        return this.parseIntegerOperation(decomposedInst, IntegerOp.Xor);
    }

    @Override
    protected Statement parseNot(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 1);
        UnaryExpression unaryExpression = new UnaryExpression(OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst), UnaryOp.Not);
        return this.newAss(decomposedInst, unaryExpression);
    }

    @Override
    protected Statement parseSub(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.Sub);
    }

    @Override
    protected Statement parseSbb(DecomposedInst decomposedInst) {
        return this.parseIntegerOperationCarry(decomposedInst, IntegerOp.Sub);
    }

    @Override
    protected Statement parseSar(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.ShiftArithmeticRight);
    }

    @Override
    protected Statement parseShr(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.ShiftRight);
    }

    @Override
    protected Statement parseSal(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.ShiftArithmeticLeft);
    }

    @Override
    protected Statement parseShl(DecomposedInst decomposedInst) {
        return this.parseIntegerOperation(decomposedInst, IntegerOp.ShiftLeft);
    }

    @Override
    protected Statement parseNop(DecomposedInst decomposedInst) {
        return this.newNop(decomposedInst);
    }

    @Override
    protected Statement parseSetX(DecomposedInst decomposedInst) {
        assert (decomposedInst.mOperands.length == 1);
        return this.newAss(decomposedInst, Condition.buildExpr(Condition.parse(decomposedInst.getOpcode())));
    }

    @Override
    protected Statement parseCondJmp(DecomposedInst decomposedInst) {
        return new JumpStmt(this.getNumber(), decomposedInst, Condition.buildExpr(Condition.parse(decomposedInst.getOpcode())), ((DecomposedInst)this.stream.peek()).getAddress(), decomposedInst.getConstantValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Statement parseJmp(DecomposedInst decomposedInst) {
        Object object;
        Expression expression;
        Object object2;
        VariablePtrDeref variablePtrDeref;
        Expression expression2 = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        if (expression2 instanceof IntConstant) {
            return new JumpStmt(this.getNumber(), decomposedInst, ((IntConstant)expression2).getValue());
        }
        if (expression2 instanceof VariablePtrDeref) {
            variablePtrDeref = (VariablePtrDeref)expression2;
        } else {
            if (!(this.next instanceof AssignmentStmt) || !(expression2 instanceof VariableRef)) throw new RuntimeException("Last statement was not an assignment: " + this.next);
            object2 = (AssignmentStmt)this.next;
            expression = (VariableRef)expression2;
            object = ((AssignmentStmt)object2).getDestination();
            if (object.size() != 1 || !(object.iterator().next() instanceof Variable) || !((Variable)object.iterator().next()).getName().equals(expression.getName())) throw new RuntimeException("Last assignment was not a jump switch: " + this.next);
            if (!(((AssignmentStmt)object2).getSource() instanceof VariablePtrDeref)) throw new RuntimeException("Last expression was not an jump table access: " + this.next);
            variablePtrDeref = (VariablePtrDeref)((AssignmentStmt)object2).getSource();
        }
        object2 = (IntegerExpr)variablePtrDeref.getExpression();
        if (((IntegerExpr)object2).getOp() != IntegerOp.Add) {
            throw new RuntimeException("Unexpected operation: " + (Object)((Object)((IntegerExpr)object2).getOp()));
        }
        expression = (IntConstant)((IntegerExpr)object2).getRight();
        object = (IntegerExpr)((IntegerExpr)object2).getLeft();
        if (((IntegerExpr)object).getOp() != IntegerOp.Mul) {
            throw new RuntimeException("Unexpected operation: " + (Object)((Object)((IntegerExpr)object).getOp()));
        }
        IntConstant intConstant = (IntConstant)((IntegerExpr)object).getRight();
        Expression expression3 = ((IntegerExpr)object).getLeft();
        if (intConstant.getValue() != 4L) {
            throw new RuntimeException("Unexpected addr size: " + intConstant.getValue());
        }
        long l = ((IntConstant)expression).getValue();
        object2 = this.readJumpTable(l);
        return new JumpStmt(this.getNumber(), decomposedInst, expression3, (ArrayList<Long>)object2);
    }

    private ArrayList<Long> readJumpTable(long l) {
        long l2;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        this.elfReader.seek(l);
        while (((l2 = (long)this.elfReader.getInt()) & 0xFFFFFFFFFFF00000L) == 0x8000000L) {
            arrayList.add(l2);
        }
        return arrayList;
    }

    @Override
    protected Statement parseCall(DecomposedInst decomposedInst) {
        CallExpr callExpr;
        Expression expression = OpParserImpl.parseOperand(decomposedInst.mOperands[0], decomposedInst);
        if (expression instanceof IntConstant) {
            long l = ((IntConstant)expression).getValue();
            String string = this.libmap.get(l);
            if (string != null) {
                LibFunction libFunction = this.app.getDynlib().getFunction(string);
                callExpr = new CallExprLinked(libFunction);
            } else {
                callExpr = new CallExprUnlinked(l);
            }
        } else {
            callExpr = new CallExprPointer(expression);
        }
        return new AssignmentStmt(this.getNumber(), decomposedInst, new LinkedList<Assignable>(), callExpr);
    }

    @Override
    protected Statement parseRet(DecomposedInst decomposedInst) {
        HashMap<VariableName, Expression> hashMap = new HashMap<VariableName, Expression>();
        if (this.retvar != null) {
            hashMap.put(this.retvar, new VariableRefUnlinked(this.retvar));
        }
        return new RetStmt(this.getNumber(), decomposedInst, hashMap);
    }

    @Override
    protected Statement parseHlt(DecomposedInst decomposedInst) {
        return new AssignmentStmt(this.getNumber(), decomposedInst, new LinkedList<Assignable>(), this.newCall(SystemFunctions.halt));
    }
}

