/*
 * Decompiled with CFR 0.152.
 */
package cfg.parser;

import cfg.Flags;
import cfg.IntConstant;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRef;
import cfg.expression.VariableRefUnlinked;
import cfg.statement.Statement;
import cfg.variable.GlobalVariable;
import cfg.variable.SsaVariable;
import cfg.variable.VariablePtrDeref;
import disassembler.diStorm3.DecomposedInst;
import disassembler.diStorm3.OpcodeEnum;
import disassembler.diStorm3.Operand;
import disassembler.diStorm3.Registers;
import elfreader.ElfReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import util.NumPrint;
import util.SymbolStream;

public abstract class OperationParser
implements SymbolStream<Statement> {
    protected SymbolStream<DecomposedInst> stream;
    Statement next;
    private int number;
    protected ElfReader elfReader;

    public OperationParser(int n, SymbolStream<DecomposedInst> symbolStream, ElfReader elfReader) {
        this.number = n;
        this.stream = symbolStream;
        this.elfReader = elfReader;
    }

    public int getNumber() {
        return this.number;
    }

    public void parse() {
        if (!this.stream.hasMore()) {
            this.next = null;
            return;
        }
        switch (this.stream.peek().getOpcode()) {
            case ADD: {
                this.next = this.parseAdd(this.stream.consume());
                break;
            }
            case ADC: {
                this.next = this.parseAdc(this.stream.consume());
                break;
            }
            case SUB: {
                this.next = this.parseSub(this.stream.consume());
                break;
            }
            case SBB: {
                this.next = this.parseSbb(this.stream.consume());
                break;
            }
            case NEG: {
                this.next = this.parseNeg(this.stream.consume());
                break;
            }
            case INC: {
                this.next = this.parseInc(this.stream.consume());
                break;
            }
            case DEC: {
                this.next = this.parseDec(this.stream.consume());
                break;
            }
            case SAL: {
                this.next = this.parseSal(this.stream.consume());
                break;
            }
            case SHL: {
                this.next = this.parseShl(this.stream.consume());
                break;
            }
            case SAR: {
                this.next = this.parseSar(this.stream.consume());
                break;
            }
            case SHR: {
                this.next = this.parseShr(this.stream.consume());
                break;
            }
            case IMUL: {
                this.next = this.parseXmul(this.stream.consume());
                break;
            }
            case MUL: {
                this.next = this.parseXmul(this.stream.consume());
                break;
            }
            case IDIV: {
                this.next = this.parseXdiv(this.stream.consume());
                break;
            }
            case DIV: {
                this.next = this.parseXdiv(this.stream.consume());
                break;
            }
            case AND: {
                this.next = this.parseAnd(this.stream.consume());
                break;
            }
            case OR: {
                this.next = this.parseOr(this.stream.consume());
                break;
            }
            case XOR: {
                this.next = this.parseXor(this.stream.consume());
                break;
            }
            case NOT: {
                this.next = this.parseNot(this.stream.consume());
                break;
            }
            case CDQ: {
                this.next = this.parseCdq(this.stream.consume());
                break;
            }
            case MOV: {
                this.next = this.parseMov(this.stream.consume());
                break;
            }
            case TEST: {
                this.next = this.parseTest(this.stream.consume());
                break;
            }
            case CMP: {
                this.next = this.parseCmp(this.stream.consume());
                break;
            }
            case LEA: {
                this.next = this.parseLea(this.stream.consume());
                break;
            }
            case PUSH: {
                this.next = this.parsePush(this.stream.consume());
                break;
            }
            case POP: {
                this.next = this.parsePop(this.stream.consume());
                break;
            }
            case MOVSX: {
                this.next = this.parseMovsx(this.stream.consume());
                break;
            }
            case MOVZX: {
                this.next = this.parseMovzx(this.stream.consume());
                break;
            }
            case MOVSD: {
                this.next = this.parseMovsd(this.stream.consume());
                break;
            }
            case MOVS: {
                this.next = this.parseMovs(this.stream.consume());
                break;
            }
            case CMOVA: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVAE: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVB: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVBE: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVZ: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVG: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVGE: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVL: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVLE: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVNZ: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVNO: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVNS: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVNP: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVO: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVP: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case CMOVS: {
                this.next = this.parseCmovx(this.stream.consume());
                break;
            }
            case LEAVE: {
                this.next = this.parseLeave(this.stream.consume());
                break;
            }
            case NOP: {
                this.next = this.parseNop(this.stream.consume());
                break;
            }
            case RET: {
                this.next = this.parseRet(this.stream.consume());
                break;
            }
            case HLT: {
                this.next = this.parseHlt(this.stream.consume());
                break;
            }
            case CALL: {
                this.next = this.parseCall(this.stream.consume());
                break;
            }
            case JMP: {
                this.next = this.parseJmp(this.stream.consume());
                break;
            }
            case JA: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JAE: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JB: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JBE: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JZ: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JG: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JGE: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JL: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JLE: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JNZ: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JNO: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JNS: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JNP: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JO: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JP: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case JS: {
                this.next = this.parseCondJmp(this.stream.consume());
                break;
            }
            case SETA: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETAE: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETB: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETBE: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETZ: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETG: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETGE: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETL: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETLE: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETNZ: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETNO: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETNS: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETNP: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETO: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETP: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            case SETS: {
                this.next = this.parseSetX(this.stream.consume());
                break;
            }
            default: {
                DecomposedInst decomposedInst = this.stream.peek();
                throw new RuntimeException("Opcode not yet supported: " + decomposedInst + " at " + NumPrint.toString(decomposedInst.getAddress()));
            }
        }
        ++this.number;
    }

    protected abstract Statement parseMov(DecomposedInst var1);

    protected abstract Statement parseMovsx(DecomposedInst var1);

    protected abstract Statement parseMovzx(DecomposedInst var1);

    protected abstract Statement parseTest(DecomposedInst var1);

    protected abstract Statement parseCmp(DecomposedInst var1);

    protected abstract Statement parseAnd(DecomposedInst var1);

    protected abstract Statement parseOr(DecomposedInst var1);

    protected abstract Statement parseXor(DecomposedInst var1);

    protected abstract Statement parseNot(DecomposedInst var1);

    protected abstract Statement parseAdd(DecomposedInst var1);

    protected abstract Statement parseAdc(DecomposedInst var1);

    protected abstract Statement parseSub(DecomposedInst var1);

    protected abstract Statement parseSbb(DecomposedInst var1);

    protected abstract Statement parseSar(DecomposedInst var1);

    protected abstract Statement parseShr(DecomposedInst var1);

    protected abstract Statement parseSal(DecomposedInst var1);

    protected abstract Statement parseShl(DecomposedInst var1);

    protected abstract Statement parseLea(DecomposedInst var1);

    protected abstract Statement parsePush(DecomposedInst var1);

    protected abstract Statement parsePop(DecomposedInst var1);

    protected abstract Statement parseLeave(DecomposedInst var1);

    protected abstract Statement parseNop(DecomposedInst var1);

    protected abstract Statement parseRet(DecomposedInst var1);

    protected abstract Statement parseHlt(DecomposedInst var1);

    protected abstract Statement parseCondJmp(DecomposedInst var1);

    protected abstract Statement parseCall(DecomposedInst var1);

    protected abstract Statement parseNeg(DecomposedInst var1);

    protected abstract Statement parseInc(DecomposedInst var1);

    protected abstract Statement parseDec(DecomposedInst var1);

    protected abstract Statement parseJmp(DecomposedInst var1);

    protected abstract Statement parseXmul(DecomposedInst var1);

    protected abstract Statement parseXdiv(DecomposedInst var1);

    protected abstract Statement parseCdq(DecomposedInst var1);

    protected abstract Statement parseSetX(DecomposedInst var1);

    protected abstract Statement parseCmovx(DecomposedInst var1);

    protected abstract Statement parseMovsd(DecomposedInst var1);

    protected abstract Statement parseMovs(DecomposedInst var1);

    protected List<SsaVariable> createDefFlagVariables(OpcodeEnum opcodeEnum) {
        LinkedList<SsaVariable> linkedList = new LinkedList<SsaVariable>();
        for (Flags flags : Flags.values()) {
            if (!opcodeEnum.defFlag(flags)) continue;
            linkedList.add(new SsaVariable(flags, this.getNumber()));
        }
        return linkedList;
    }

    protected Collection<VariableRef> createUsedFlagsVariables(OpcodeEnum opcodeEnum) {
        LinkedList<VariableRef> linkedList = new LinkedList<VariableRef>();
        for (Flags flags : Flags.values()) {
            if (!opcodeEnum.useFlag(flags)) continue;
            linkedList.add(new VariableRefUnlinked(flags));
        }
        return linkedList;
    }

    public static Expression parseOperand(Operand operand, DecomposedInst decomposedInst) {
        switch (operand.getType()) {
            case Reg: {
                return new VariableRefUnlinked(Registers.getRegisterByIndex(operand.getIndex()));
            }
            case Disp: {
                return new GlobalVariable(Registers.getDisplacementReg(operand.getIndex()), decomposedInst.mDisp.getDisplacement());
            }
            case Imm: {
                return new IntConstant(decomposedInst.mImm.getImm());
            }
            case Smem: {
                IntegerExpr integerExpr = new IntegerExpr(new VariableRefUnlinked(Registers.getRegisterByIndex(operand.getIndex())), new IntConstant(decomposedInst.mDisp.getDisplacement()), IntegerOp.Add);
                return new VariablePtrDeref(integerExpr);
            }
            case Mem: {
                IntegerExpr integerExpr = new IntegerExpr(new VariableRefUnlinked(Registers.getRegisterByIndex(operand.getIndex())), new IntConstant(Math.max(decomposedInst.getScale(), 1)), IntegerOp.Mul);
                Expression expression = new IntConstant(decomposedInst.mDisp.getDisplacement());
                if (decomposedInst.getBase() < Registers.values().length) {
                    expression = new IntegerExpr(new VariableRefUnlinked(Registers.getRegisterByIndex(decomposedInst.getBase())), expression, IntegerOp.Add);
                }
                IntegerExpr integerExpr2 = new IntegerExpr(integerExpr, expression, IntegerOp.Add);
                return new VariablePtrDeref(integerExpr2);
            }
            case Pc: {
                return new IntConstant(decomposedInst.mImm.getImm() + decomposedInst.mDisp.getDisplacement() + decomposedInst.getAddress() + (long)decomposedInst.getSize());
            }
        }
        throw new RuntimeException("Operand parser not yet implemented: " + decomposedInst);
    }

    @Override
    public Statement peek() {
        return this.next;
    }

    @Override
    public Statement consume() {
        Statement statement = this.next;
        this.parse();
        return statement;
    }

    @Override
    public boolean hasMore() {
        return this.next != null;
    }
}

