/*
 * Decompiled with CFR 0.152.
 */
package cfg.parser;

import cfg.Assignable;
import cfg.Flags;
import cfg.IntConstant;
import cfg.expression.IntegerOp;
import cfg.matcher.Matcher;
import cfg.matcher.MultiMatcher;
import cfg.matcher.PushMatcher;
import cfg.matcher.VarCopyMatcher;
import cfg.matcher.VarnameIntOpChangeMatcher;
import cfg.statement.AssignmentStmt;
import cfg.statement.PhiStmt;
import cfg.statement.Statement;
import cfg.variable.SsaVariable;
import cfg.variable.VariableName;
import disassembler.diStorm3.Registers;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PrologParser {
    private LinkedList<VariableName> stack = new LinkedList();
    private long stacksize = 0L;
    private boolean foundStacksize = false;
    private boolean useEbpAsStackAddressing = false;

    public PrologParser(List<Statement> list) {
        this.parse(list);
    }

    public List<VariableName> getStack() {
        return this.stack;
    }

    public long getStacksize() {
        return this.stacksize;
    }

    public boolean useEbpAsStackAddressing() {
        return this.useEbpAsStackAddressing;
    }

    private void parse(List<Statement> list) {
        HashSet<Matcher> hashSet = new HashSet<Matcher>();
        hashSet.add(new PushMatcher());
        hashSet.add(new VarCopyMatcher(Registers.EBP, Registers.ESP));
        hashSet.add(new VarnameIntOpChangeMatcher(Registers.ESP));
        MultiMatcher multiMatcher = new MultiMatcher(hashSet);
        for (int i = 0; i < list.size(); ++i) {
            Statement statement = list.get(i);
            Set<? extends Matcher> set = multiMatcher.match(statement);
            if (set.size() > 1) {
                throw new RuntimeException("Very unexpected behaviour");
            }
            if (set.isEmpty()) break;
            Matcher matcher = set.iterator().next();
            if (matcher instanceof PushMatcher) {
                this.stack.push(((PushMatcher)matcher).getVariable());
            } else if (matcher instanceof VarCopyMatcher) {
                this.useEbpAsStackAddressing = true;
                list.add(0, new PhiStmt(new SsaVariable(((VarCopyMatcher)matcher).getDst(), 0)));
                ++i;
            } else if (matcher instanceof VarnameIntOpChangeMatcher) {
                VarnameIntOpChangeMatcher varnameIntOpChangeMatcher = (VarnameIntOpChangeMatcher)matcher;
                assert (!this.foundStacksize);
                assert (varnameIntOpChangeMatcher.getOp() == IntegerOp.Sub);
                this.foundStacksize = true;
                this.stacksize = varnameIntOpChangeMatcher.getValue();
            }
            statement.setDeleted();
        }
        list.add(0, new PhiStmt(new SsaVariable(Registers.ESP, 0)));
        LinkedList<Assignable> linkedList = new LinkedList<Assignable>();
        linkedList.add(new SsaVariable(Flags.Direction, 0));
        list.add(0, new AssignmentStmt(0, linkedList, new IntConstant(0L)));
    }
}

