/*
 * Decompiled with CFR 0.152.
 */
package cfg.statement;

import cfg.Assignable;
import cfg.IrElement;
import cfg.IrType;
import cfg.expression.Expression;
import cfg.statement.Assignment;
import cfg.statement.Statement;
import disassembler.diStorm3.DecomposedInst;
import java.util.ArrayList;
import java.util.List;

public class AssignmentStmt
extends Statement
implements Assignment {
    private List<Assignable> destination;
    private Expression source;

    public AssignmentStmt(int n, DecomposedInst decomposedInst, List<Assignable> list, Expression expression) {
        super(n, decomposedInst);
        this.destination = list;
        this.source = expression;
    }

    public AssignmentStmt(int n, List<Assignable> list, Expression expression) {
        super(n, null);
        this.destination = list;
        this.source = expression;
    }

    @Override
    public List<Assignable> getDestination() {
        return this.destination;
    }

    public Expression getSource() {
        return this.source;
    }

    public void setSource(Expression expression) {
        assert (expression != null);
        this.source = expression;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.destination.isEmpty()) {
            boolean bl = true;
            for (Assignable assignable : this.destination) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(assignable);
            }
            stringBuilder.append(" := ");
        }
        stringBuilder.append(this.source);
        return stringBuilder.toString();
    }

    @Override
    public IrType getIrType() {
        return IrType.AssignmentStmt;
    }

    @Override
    public List<? extends IrElement> getChildren() {
        ArrayList<Assignable> arrayList = new ArrayList<Assignable>(this.destination);
        arrayList.add((Assignable)((Object)this.source));
        return arrayList;
    }
}

