/*
 * Decompiled with CFR 0.152.
 */
package cfg.statement;

import cfg.Assignable;
import cfg.IrElement;
import cfg.IrType;
import cfg.expression.Expression;
import cfg.statement.Assignment;
import cfg.statement.Statement;
import cfg.variable.SsaVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import util.NumPrint;

public class PhiStmt
extends Statement
implements Assignment {
    private HashMap<Long, Expression> option = new HashMap();
    private SsaVariable varname;

    public PhiStmt(SsaVariable ssaVariable) {
        this.varname = ssaVariable;
    }

    public void setVarname(SsaVariable ssaVariable) {
        this.varname = ssaVariable;
    }

    public SsaVariable getVarname() {
        return this.varname;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.varname);
        stringBuilder.append(" := phi( ");
        for (Long l : this.option.keySet()) {
            stringBuilder.append(NumPrint.toString(l));
            stringBuilder.append("::");
            stringBuilder.append(this.option.get(l));
            stringBuilder.append("; ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void addPredvar(Long l, Expression expression) {
        assert (!this.option.containsKey(l));
        this.option.put(l, expression);
    }

    public HashMap<Long, Expression> getOption() {
        return this.option;
    }

    @Override
    public List<Assignable> getDestination() {
        ArrayList<Assignable> arrayList = new ArrayList<Assignable>(1);
        arrayList.add(this.varname);
        return arrayList;
    }

    @Override
    public int getNumber() {
        return this.varname.getVersion();
    }

    @Override
    public IrType getIrType() {
        return IrType.PhiStmt;
    }

    @Override
    public List<? extends IrElement> getChildren() {
        return new ArrayList<Expression>(this.option.values());
    }
}

