/*
 * Decompiled with CFR 0.152.
 */
package cfg.unlinker;

import cfg.Assignable;
import cfg.IrElement;
import cfg.IrTraverser;
import cfg.IrType;
import cfg.basicblock.BasicBlock;
import cfg.expression.Expression;
import cfg.expression.VariableRefUnlinked;
import cfg.function.FuncProtParam;
import cfg.function.PrgFunction;
import cfg.statement.AssignmentStmt;
import cfg.statement.PhiStmt;
import cfg.statement.Statement;
import cfg.unlinker.HllVariable;
import cfg.variable.SsaVariable;
import java.util.ArrayList;
import java.util.Collection;

public class SimpleSsaBacktranslation
extends IrTraverser<Void, Void> {
    private PrgFunction func;
    private BasicBlock phibb = null;

    public static void translate(Collection<PrgFunction> collection) {
        SimpleSsaBacktranslation simpleSsaBacktranslation = new SimpleSsaBacktranslation();
        simpleSsaBacktranslation.visit(collection, null);
    }

    @Override
    protected Void visitAssignmentStmt(AssignmentStmt assignmentStmt, Void void_) {
        super.visitAssignmentStmt(assignmentStmt, void_);
        if (assignmentStmt.getSource().getIrType() == IrType.PhiStmt) {
            throw new RuntimeException("should not reach this code");
        }
        return null;
    }

    @Override
    protected Void visitPhiStmt(PhiStmt phiStmt, Void void_) {
        IrElement irElement;
        for (FuncProtParam object2 : this.func.getParam()) {
            if (!object2.name.equals(phiStmt.getVarname().getName().toString())) continue;
            phiStmt.setDeleted();
            return null;
        }
        assert (this.func != null);
        HllVariable hllVariable = new HllVariable(phiStmt.getVarname().getName() + "_t");
        for (Long l : phiStmt.getOption().keySet()) {
            irElement = this.func.getGraph().getVertex(l);
            Expression expression = phiStmt.getOption().get(l);
            SsaVariable ssaVariable = new SsaVariable(hllVariable, 0);
            ArrayList<Assignable> arrayList = new ArrayList<Assignable>();
            arrayList.add(ssaVariable);
            AssignmentStmt assignmentStmt = new AssignmentStmt(0, arrayList, expression);
            ((BasicBlock)irElement).getCode().add(((BasicBlock)irElement).getCode().size() - 1, assignmentStmt);
        }
        SsaVariable ssaVariable = new SsaVariable(phiStmt.getVarname().getName(), 0);
        ArrayList<Assignable> arrayList = new ArrayList<Assignable>();
        arrayList.add(ssaVariable);
        irElement = new AssignmentStmt(0, arrayList, new VariableRefUnlinked(hllVariable));
        this.phibb.getCode().add(this.phibb.getCode().indexOf(phiStmt), (Statement)irElement);
        phiStmt.setDeleted();
        return null;
    }

    @Override
    protected Void visitPrgFunction(PrgFunction prgFunction, Void void_) {
        assert (this.func == null);
        this.func = prgFunction;
        super.visitPrgFunction(prgFunction, void_);
        assert (this.func == prgFunction);
        this.func = null;
        return null;
    }

    @Override
    protected Void visitBasicBlock(BasicBlock basicBlock, Void void_) {
        assert (this.phibb == null);
        this.phibb = basicBlock;
        for (int i = 0; i < basicBlock.getCode().size(); ++i) {
            Statement statement = basicBlock.getCode().get(i);
            this.visit(statement, void_);
        }
        assert (this.phibb == basicBlock);
        this.phibb = null;
        return null;
    }
}

