/*
 * Decompiled with CFR 0.152.
 */
package codewriter;

import cfg.IrTraverser;
import cfg.basicblock.BasicBlock;
import cfg.function.PrgFunction;
import cfg.statement.Statement;
import codewriter.Writer;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;
import util.NumPrint;

public class BbWriter
extends IrTraverser<Void, Writer> {
    public static void write(Collection<PrgFunction> collection, String string) {
        BbWriter bbWriter = new BbWriter();
        try {
            bbWriter.visit(collection, new Writer(new PrintStream(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    protected Void visitPrgFunction(PrgFunction prgFunction, Writer writer) {
        writer.wrln(prgFunction.toString() + ":");
        super.visitPrgFunction(prgFunction, writer);
        writer.wrln("--------------------");
        writer.wrln("");
        return null;
    }

    @Override
    protected Void visitBasicBlock(BasicBlock basicBlock, Writer writer) {
        writer.wrln(NumPrint.toString(basicBlock.getId()) + ":");
        super.visitBasicBlock(basicBlock, writer);
        writer.wrln("");
        return null;
    }

    @Override
    protected Void visitStatement(Statement statement, Writer writer) {
        if (!statement.isDeleted()) {
            writer.wrln(statement);
        }
        return null;
    }
}

