/*
 * Decompiled with CFR 0.152.
 */
package codewriter;

import ast.Ast;
import ast.PrgFunc;
import ast.Program;
import ast.traverser.AstTraverser;
import ast.type.Type;
import codewriter.CodeWriterStatement;
import codewriter.InfoWriter;
import codewriter.Writer;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class CodeWriter
extends AstTraverser<Writer> {
    public CodeWriter(InfoWriter infoWriter) {
        super(new CodeWriterStatement(infoWriter));
    }

    public static void write(Ast ast, InfoWriter infoWriter, String string) {
        CodeWriter codeWriter = new CodeWriter(infoWriter);
        try {
            codeWriter.visit(ast, new Writer(new PrintStream(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    @Override
    protected Ast visitProgram(Program program, Writer writer) {
        writer.wr("public class " + program.getOutputName() + " {");
        writer.nl();
        writer.incIndent();
        super.visitProgram(program, writer);
        writer.decIndent();
        writer.wr("}");
        writer.nl();
        return program;
    }

    @Override
    protected Ast visitPrgFunc(PrgFunc prgFunc, Writer writer) {
        writer.wr("public ");
        writer.wr(CodeWriter.getTypeString(prgFunc.getReturnType()) + " " + prgFunc.getName() + "( ");
        for (int i = 0; i < prgFunc.getParam().size(); ++i) {
            if (i > 0) {
                writer.wr(", ");
            }
            this.getStmt().visit(prgFunc.getParam().get(i), writer);
        }
        writer.wr(") ");
        this.visit(prgFunc.getBody(), writer);
        writer.nl();
        return prgFunc;
    }

    public static String getTypeString(Type type) {
        switch (type) {
            case Integer: {
                return "int";
            }
            case Pointer: {
                return "Pointer<Integer>";
            }
            case Void: {
                return "void";
            }
        }
        return (Object)((Object)type) + "?";
    }
}

