/*
 * Decompiled with CFR 0.152.
 */
package codewriter;

import ast.Function;
import ast.LibFuncs;
import ast.expression.ArithmeticExpr;
import ast.expression.BooleanConstant;
import ast.expression.CallExpr;
import ast.expression.CompareExpr;
import ast.expression.Expression;
import ast.expression.FunctionRef;
import ast.expression.FunctionRefLinked;
import ast.expression.FunctionRefUnlinked;
import ast.expression.IfExpr;
import ast.expression.IntConstant;
import ast.expression.IntegerOp;
import ast.expression.NullConstExpr;
import ast.expression.StringConstant;
import ast.expression.UnaryExpression;
import ast.expression.VariablePtrDeref;
import ast.expression.VariablePtrOf;
import ast.traverser.AstExpressionTraverser;
import ast.variable.ArrayAccess;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import ast.variable.VariableRefUnlinked;
import codewriter.CodeWriter;
import codewriter.Writer;
import util.NumPrint;

class CodeWriterExpression
extends AstExpressionTraverser<Writer> {
    CodeWriterExpression() {
    }

    public void emitFuncCallParam(CallExpr callExpr, Writer writer) {
        writer.wr("(");
        for (int i = 0; i < callExpr.getParam().size(); ++i) {
            if (i > 0) {
                writer.wr(", ");
            }
            this.visit(callExpr.getParam().get(i), writer);
        }
        writer.wr(")");
    }

    @Override
    public Variable visit(Variable variable, Writer writer) {
        writer.wr(CodeWriter.getTypeString(variable.getType()));
        writer.wr(" ");
        writer.wr(variable.getName());
        return variable;
    }

    @Override
    protected Expression visitCallExpr(CallExpr callExpr, Writer writer) {
        if (callExpr.getFunction() instanceof FunctionRefLinked) {
            Function function = ((FunctionRefLinked)callExpr.getFunction()).getFunc();
            if (function == LibFuncs.ptrNew || function == LibFuncs.ptrCopy) {
                writer.wr("new Pointer<Integer>");
                this.emitFuncCallParam(callExpr, writer);
            } else if (function == LibFuncs.ptrDestroy) {
                this.visit(callExpr.getParam().get(0), writer);
                writer.wr(".free()");
            } else if (function == LibFuncs.ptrGetValue) {
                this.visit(callExpr.getParam().get(0), writer);
                writer.wr(".getValue( ");
                this.visit(callExpr.getParam().get(1), writer);
                writer.wr(" )");
            } else if (function == LibFuncs.ptrSetValue) {
                this.visit(callExpr.getParam().get(0), writer);
                writer.wr(".setValue( ");
                this.visit(callExpr.getParam().get(1), writer);
                writer.wr(", ");
                this.visit(callExpr.getParam().get(2), writer);
                writer.wr(" )");
            } else {
                this.visit(callExpr.getFunction(), writer);
                this.emitFuncCallParam(callExpr, writer);
            }
        } else {
            this.visit(callExpr.getFunction(), writer);
            this.emitFuncCallParam(callExpr, writer);
        }
        return callExpr;
    }

    @Override
    protected FunctionRef visitFunctionRefLinked(FunctionRefLinked functionRefLinked, Writer writer) {
        writer.wr(functionRefLinked.getFunc().getName());
        return functionRefLinked;
    }

    @Override
    protected FunctionRef visitFunctionRefUnlinked(FunctionRefUnlinked functionRefUnlinked, Writer writer) {
        writer.wr("unlinked_function_at_" + NumPrint.toString(functionRefUnlinked.getAddr()) + "(" + functionRefUnlinked.getTag() + ")");
        return functionRefUnlinked;
    }

    @Override
    protected Expression visitUnaryExpression(UnaryExpression unaryExpression, Writer writer) {
        writer.wr("(");
        writer.wr((Object)unaryExpression.getOp());
        this.visit(unaryExpression.getExpr(), writer);
        writer.wr(")");
        return unaryExpression;
    }

    @Override
    protected Expression visitVariableRefUnlinked(VariableRefUnlinked variableRefUnlinked, Writer writer) {
        writer.wr("'" + variableRefUnlinked.getName().toString() + "'");
        return variableRefUnlinked;
    }

    @Override
    protected Expression visitVariableRefLinked(VariableRefLinked variableRefLinked, Writer writer) {
        writer.wr(variableRefLinked.getReference().getName());
        return variableRefLinked;
    }

    @Override
    protected Expression visitBooleanConstant(BooleanConstant booleanConstant, Writer writer) {
        writer.wr(booleanConstant.getValue());
        return booleanConstant;
    }

    @Override
    protected Expression visitNullConstExpr(NullConstExpr nullConstExpr, Writer writer) {
        writer.wr("null");
        return nullConstExpr;
    }

    @Override
    protected Expression visitConstant(IntConstant intConstant, Writer writer) {
        writer.wr(intConstant.getValue());
        return intConstant;
    }

    @Override
    protected Expression visitStringConstant(StringConstant stringConstant, Writer writer) {
        writer.wr("\"" + stringConstant.getContent() + "\"");
        return stringConstant;
    }

    @Override
    protected Expression visitIfExpr(IfExpr ifExpr, Writer writer) {
        writer.wr("( ");
        this.visit(ifExpr.getCondition(), writer);
        writer.wr(" ? ");
        this.visit(ifExpr.getLeft(), writer);
        writer.wr(" : ");
        this.visit(ifExpr.getRight(), writer);
        writer.wr(" )");
        return ifExpr;
    }

    @Override
    protected Expression visitArithmeticExpr(ArithmeticExpr arithmeticExpr, Writer writer) {
        writer.wr("(");
        this.visit(arithmeticExpr.getLeft(), writer);
        writer.wr(" ");
        writer.wr(this.getOpStr(arithmeticExpr.getOp()));
        writer.wr(" ");
        this.visit(arithmeticExpr.getRight(), writer);
        writer.wr(")");
        return arithmeticExpr;
    }

    private Object getOpStr(IntegerOp integerOp) {
        switch (integerOp) {
            case And: {
                return "&";
            }
            case Or: {
                return "|";
            }
            case Xor: {
                return "^";
            }
            case Add: {
                return "+";
            }
            case Sub: {
                return "-";
            }
            case Mul: {
                return "*";
            }
            case Div: {
                return "/";
            }
            case ShiftRight: {
                return ">>";
            }
            case ShiftLeft: {
                return "<<";
            }
        }
        throw new RuntimeException("Not yet implemneted: " + (Object)((Object)integerOp));
    }

    @Override
    protected Expression visitCompareExpr(CompareExpr compareExpr, Writer writer) {
        writer.wr("(");
        this.visit(compareExpr.getLeft(), writer);
        writer.wr(" ");
        writer.wr((Object)compareExpr.getOperand());
        writer.wr(" ");
        this.visit(compareExpr.getRight(), writer);
        writer.wr(")");
        return compareExpr;
    }

    @Override
    protected Expression visitArrayAccess(ArrayAccess arrayAccess, Writer writer) {
        this.visit(arrayAccess.getBase(), writer);
        writer.wr("[");
        this.visit(arrayAccess.getIndex(), writer);
        writer.wr("]");
        return arrayAccess;
    }

    @Override
    protected Expression visitVariablePtrOf(VariablePtrOf variablePtrOf, Writer writer) {
        writer.wr("&");
        this.visit(variablePtrOf.getVar(), writer);
        return variablePtrOf;
    }

    @Override
    protected Expression visitVariablePtrDeref(VariablePtrDeref variablePtrDeref, Writer writer) {
        writer.wr("*");
        this.visit(variablePtrDeref.getExpr(), writer);
        return variablePtrDeref;
    }
}

