/*
 * Decompiled with CFR 0.152.
 */
package codewriter;

import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.BlockStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.NullStmt;
import ast.statement.RetStmt;
import ast.statement.Statement;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.traverser.AstStatementTraverser;
import ast.traverser.ReturnChecker;
import ast.type.Type;
import ast.variable.Variable;
import codewriter.CodeWriterExpression;
import codewriter.InfoWriter;
import codewriter.Writer;
import util.NumPrint;

class CodeWriterStatement
extends AstStatementTraverser<Writer> {
    private CodeWriterExpression exptrav = new CodeWriterExpression();
    private InfoWriter info;

    public CodeWriterStatement(InfoWriter infoWriter) {
        this.info = infoWriter;
    }

    @Override
    public Expression visit(Expression expression, Writer writer) {
        return this.exptrav.visit(expression, writer);
    }

    @Override
    public Variable visit(Variable variable, Writer writer) {
        return this.exptrav.visit(variable, writer);
    }

    private void printInfo(Statement statement, Writer writer) {
        if (this.info != null) {
            writer.wr("\t//");
            writer.wr(this.info.get(statement));
        }
    }

    @Override
    protected Statement visitNullStmt(NullStmt nullStmt, Writer writer) {
        writer.wr(";");
        writer.nl();
        return nullStmt;
    }

    @Override
    protected Statement visitVarDef(VarDef varDef, Writer writer) {
        this.visit(varDef.getVariable(), writer);
        if (varDef.getVariable().getSize() > 1) {
            assert (varDef.getVariable().getType() == Type.Pointer);
            writer.wr(" = new Pointer<Integer>( ");
            writer.wr(varDef.getVariable().getSize());
            writer.wr(" )");
        } else {
            writer.wr(" = ");
            writer.wr(varDef.getVariable().getType() == Type.Pointer ? "null" : "0");
        }
        writer.wr(";");
        this.printInfo(varDef, writer);
        writer.nl();
        return varDef;
    }

    @Override
    protected Statement visitCallStmt(CallStmt callStmt, Writer writer) {
        this.visit((Expression)callStmt.getCall(), writer);
        writer.wr(";");
        this.printInfo(callStmt, writer);
        writer.nl();
        return callStmt;
    }

    @Override
    protected Statement visitRetStmt(RetStmt retStmt, Writer writer) {
        writer.wr("return ");
        this.visit(retStmt.getRetval(), writer);
        writer.wr(";");
        this.printInfo(retStmt, writer);
        writer.nl();
        return retStmt;
    }

    @Override
    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, Writer writer) {
        this.visit(assignmentStmt.getDestination(), writer);
        writer.wr(" = ");
        this.visit(assignmentStmt.getSource(), writer);
        writer.wr(";");
        this.printInfo(assignmentStmt, writer);
        writer.nl();
        return assignmentStmt;
    }

    @Override
    protected Statement visitDoWhileStmt(DoWhile doWhile, Writer writer) {
        writer.wr("do ");
        this.visit(doWhile.getBody(), writer);
        writer.wr("while( ");
        this.visit(doWhile.getCondition(), writer);
        writer.wr(" )");
        writer.wr(";");
        this.printInfo(doWhile, writer);
        writer.nl();
        return doWhile;
    }

    @Override
    protected Statement visitWhileStmt(WhileStmt whileStmt, Writer writer) {
        writer.wr("while( ");
        this.visit(whileStmt.getCondition(), writer);
        writer.wr(" )");
        this.visit(whileStmt.getBody(), writer);
        this.printInfo(whileStmt, writer);
        return whileStmt;
    }

    @Override
    protected Statement visitBlockStmt(BlockStmt blockStmt, Writer writer) {
        writer.wr("{");
        this.printInfo(blockStmt, writer);
        writer.nl();
        writer.incIndent();
        this.visit(blockStmt.getBlock(), writer);
        writer.decIndent();
        writer.wr("}");
        writer.nl();
        return blockStmt;
    }

    @Override
    protected Statement visitIfStmt(IfStmt ifStmt, Writer writer) {
        writer.wr("if( ");
        this.visit(ifStmt.getCondition(), writer);
        writer.wr(") ");
        this.visit(ifStmt.getThenBranch(), writer);
        if (!(ifStmt.getElseBranch() instanceof NullStmt)) {
            writer.wr("else ");
            this.visit(ifStmt.getElseBranch(), writer);
        }
        this.printInfo(ifStmt, writer);
        writer.nl();
        return ifStmt;
    }

    @Override
    protected Statement visitCaseStmt(CaseStmt caseStmt, Writer writer) {
        writer.wr("switch( ");
        this.visit(caseStmt.getCondition(), writer);
        writer.wr(" ){");
        this.printInfo(caseStmt, writer);
        writer.nl();
        writer.incIndent();
        for (int n : caseStmt.getOption().keySet()) {
            writer.wr("case ");
            writer.wr(NumPrint.toString(n));
            writer.wr(": {");
            writer.nl();
            writer.incIndent();
            this.visit(caseStmt.getOption().get(n), writer);
            if (ReturnChecker.comesBack(caseStmt.getOption().get(n))) {
                writer.wr("break;");
                writer.nl();
            }
            writer.decIndent();
            writer.wr("}");
            writer.nl();
        }
        if (!(caseStmt.getOther() instanceof NullStmt)) {
            writer.wr("default:");
            this.visit(caseStmt.getOther(), writer);
        }
        writer.decIndent();
        writer.wr("}");
        writer.nl();
        return caseStmt;
    }
}

