/*
 * Decompiled with CFR 0.152.
 */
package codewriter;

import codewriter.Writer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class SupportWriter {
    public static void generateFiles(String string) {
        try {
            PrintStream printStream = new PrintStream(string + File.separator + "Main.java");
            Writer writer = new Writer(printStream);
            SupportWriter.generateMain(writer);
            printStream.close();
            printStream = new PrintStream(string + File.separator + "IoSupport.java");
            writer = new Writer(printStream);
            SupportWriter.generateIoSupport(writer);
            printStream.close();
            printStream = new PrintStream(string + File.separator + "Pointer.java");
            writer = new Writer(printStream);
            SupportWriter.generatePointer(writer);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private static void generatePointer(Writer writer) {
        writer.wrln("import java.util.ArrayList;");
        writer.nl();
        writer.wrln("public class Pointer<T> {");
        writer.wrln("  private ArrayList<T> memory;");
        writer.wrln("  private int          position = 0;");
        writer.nl();
        writer.wrln("  public Pointer(int n) {");
        writer.wrln("    memory = new ArrayList<T>(n);");
        writer.wrln("    for (int i = 0; i < n; i++) {");
        writer.wrln("      memory.add(null);");
        writer.wrln("    }");
        writer.wrln("  }");
        writer.nl();
        writer.wrln("  public Pointer(Pointer<T> old, int displacement) {");
        writer.wrln("    memory = old.memory;");
        writer.wrln("    position = old.position + displacement;");
        writer.wrln("  }");
        writer.nl();
        writer.wrln("  public void free() {");
        writer.wrln("    memory.clear();");
        writer.wrln("  }");
        writer.nl();
        writer.wrln("  public T getValue(int offset) {");
        writer.wrln("    return memory.get(position + offset);");
        writer.wrln("  }");
        writer.nl();
        writer.wrln("  public void setValue(int offset, T value) {");
        writer.wrln("    memory.set(position + offset, value);");
        writer.wrln("  }");
        writer.wrln("}");
    }

    private static void generateIoSupport(Writer writer) {
        writer.wrln("import java.util.Scanner;");
        writer.nl();
        writer.wrln("public class IoSupport {");
        writer.wrln("  private static Scanner s   = new Scanner(System.in);");
        writer.nl();
        writer.wrln("  public static int readInt() {");
        writer.wrln("    return s.nextInt();");
        writer.wrln("  }");
        writer.nl();
        writer.wrln("  public static void writeStr(String string) {");
        writer.wrln("    System.out.print(string);");
        writer.wrln("  }");
        writer.nl();
        writer.wrln("  public static void writeNl() {");
        writer.wrln("    System.out.println();");
        writer.wrln("  }");
        writer.nl();
        writer.wrln("  public static void writeInt(int value) {");
        writer.wrln("    System.out.print(value);");
        writer.wrln("  }");
        writer.wrln("}");
    }

    private static void generateMain(Writer writer) {
        writer.wrln("public class Main {");
        writer.wrln("  public static void main(String[] args) {");
        writer.wrln("    UserPrg user = new UserPrg();");
        writer.wrln("    System.exit(user.main());");
        writer.wrln("  }");
        writer.wrln("}");
    }
}

