/*
 * Decompiled with CFR 0.152.
 */
package dataflow;

import ast.PrgFunc;
import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.NullStmt;
import ast.statement.RetStmt;
import ast.statement.Statement;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.traverser.AstStatementTraverser;
import ast.variable.Variable;
import dataflow.DfVertex;
import graph.BaseGraph;
import graph.SimpleEdge;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jgrapht.DirectedGraph;

public abstract class GraphBuilder<T>
extends AstStatementTraverser<Void> {
    private DirectedGraph<DfVertex<T>, SimpleEdge<DfVertex<T>>> graph;
    private DfVertex<T> last;
    private Map<DfVertex<T>, Statement> invmapping = new HashMap<DfVertex<T>, Statement>();
    private Map<Statement, DfVertex<T>> mapping = new HashMap<Statement, DfVertex<T>>();

    public DirectedGraph<DfVertex<T>, SimpleEdge<DfVertex<T>>> build(PrgFunc prgFunc) {
        this.graph = new BaseGraph<DfVertex<T>, SimpleEdge<DfVertex<T>>>();
        DfVertex<T> dfVertex = this.createVertex(prgFunc);
        this.graph.addVertex(dfVertex);
        this.visit(prgFunc.getBody(), null);
        return this.graph;
    }

    public final DirectedGraph<DfVertex<T>, SimpleEdge<DfVertex<T>>> getGraph() {
        return this.graph;
    }

    public final Map<DfVertex<T>, Statement> getInvMapping() {
        return this.invmapping;
    }

    public final Map<Statement, DfVertex<T>> getMapping() {
        return this.mapping;
    }

    private void addVertex(Statement statement, DfVertex<T> dfVertex) {
        this.graph.addVertex(dfVertex);
        this.invmapping.put(dfVertex, statement);
        this.mapping.put(statement, dfVertex);
    }

    private void addEdge(DfVertex<T> dfVertex, DfVertex<T> dfVertex2) {
        if (dfVertex != null && dfVertex2 != null) {
            SimpleEdge<DfVertex<T>> simpleEdge = new SimpleEdge<DfVertex<T>>(dfVertex, dfVertex2);
            this.graph.addEdge(simpleEdge.getSrc(), simpleEdge.getDst(), simpleEdge);
        }
    }

    protected abstract DfVertex<T> createVertex();

    protected abstract DfVertex<T> createVertex(PrgFunc var1);

    @Override
    protected Statement visitNullStmt(NullStmt nullStmt, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(nullStmt);
        this.addVertex(nullStmt, dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = dfVertex;
        return nullStmt;
    }

    protected abstract DfVertex<T> createVertex(NullStmt var1);

    @Override
    protected Statement visitVarDef(VarDef varDef, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(varDef);
        this.addVertex(varDef, dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = dfVertex;
        return varDef;
    }

    protected abstract DfVertex<T> createVertex(VarDef var1);

    @Override
    protected Statement visitCallStmt(CallStmt callStmt, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(callStmt);
        this.addVertex(callStmt, dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = dfVertex;
        return callStmt;
    }

    protected abstract DfVertex<T> createVertex(CallStmt var1);

    @Override
    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(assignmentStmt);
        this.addVertex(assignmentStmt, dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = dfVertex;
        return assignmentStmt;
    }

    protected abstract DfVertex<T> createVertex(AssignmentStmt var1);

    @Override
    protected Statement visitRetStmt(RetStmt retStmt, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(retStmt);
        this.addVertex(retStmt, dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = null;
        return retStmt;
    }

    protected abstract DfVertex<T> createVertex(RetStmt var1);

    @Override
    protected Statement visitIfStmt(IfStmt ifStmt, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(ifStmt);
        this.addVertex(ifStmt, dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = dfVertex;
        this.visit(ifStmt.getThenBranch(), null);
        DfVertex<T> dfVertex2 = this.last;
        this.last = dfVertex;
        this.visit(ifStmt.getElseBranch(), null);
        DfVertex<T> dfVertex3 = this.last;
        DfVertex<T> dfVertex4 = this.createVertex();
        this.graph.addVertex(dfVertex4);
        this.addEdge(dfVertex2, dfVertex4);
        this.addEdge(dfVertex3, dfVertex4);
        this.last = dfVertex4;
        return ifStmt;
    }

    protected abstract DfVertex<T> createVertex(IfStmt var1);

    @Override
    protected Statement visitCaseStmt(CaseStmt caseStmt, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(caseStmt);
        this.addVertex(caseStmt, dfVertex);
        this.addEdge(this.last, dfVertex);
        DfVertex<T> dfVertex2 = this.createVertex();
        this.graph.addVertex(dfVertex2);
        HashSet<Statement> hashSet = new HashSet<Statement>(caseStmt.getOption().values());
        hashSet.add(caseStmt.getOther());
        for (Statement statement : hashSet) {
            this.last = dfVertex;
            this.visit(statement, null);
            DfVertex<T> dfVertex3 = this.last;
            this.addEdge(dfVertex3, dfVertex2);
        }
        this.last = dfVertex2;
        return caseStmt;
    }

    protected abstract DfVertex<T> createVertex(CaseStmt var1);

    @Override
    protected Statement visitWhileStmt(WhileStmt whileStmt, Void void_) {
        DfVertex<T> dfVertex = this.createVertex(whileStmt);
        this.addVertex(whileStmt, dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = dfVertex;
        this.visit(whileStmt.getBody(), null);
        DfVertex<T> dfVertex2 = this.createVertex();
        this.graph.addVertex(dfVertex2);
        this.addEdge(this.last, dfVertex2);
        this.addEdge(dfVertex2, dfVertex);
        this.last = dfVertex2;
        return whileStmt;
    }

    protected abstract DfVertex<T> createVertex(WhileStmt var1);

    @Override
    protected Statement visitDoWhileStmt(DoWhile doWhile, Void void_) {
        DfVertex<T> dfVertex = this.createVertex();
        this.graph.addVertex(dfVertex);
        this.addEdge(this.last, dfVertex);
        this.last = dfVertex;
        this.visit(doWhile.getBody(), null);
        DfVertex<T> dfVertex2 = this.createVertex(doWhile);
        this.addVertex(doWhile, dfVertex2);
        this.addEdge(this.last, dfVertex2);
        this.addEdge(dfVertex2, dfVertex);
        this.last = dfVertex2;
        return doWhile;
    }

    protected abstract DfVertex<T> createVertex(DoWhile var1);

    @Override
    public Expression visit(Expression expression, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Variable visit(Variable variable, Void void_) {
        throw new RuntimeException("Not yet implemented");
    }
}

