/*
 * Decompiled with CFR 0.152.
 */
package dataflow.copyprop;

import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.NullStmt;
import ast.statement.Statement;
import ast.traverser.AstStatementTraverser;
import ast.traverser.AstTraverser;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import dataflow.copyprop.ExprCopyReplacer;
import java.util.Map;

public class CopyReplacer
extends AstStatementTraverser<Map<Variable, Variable>> {
    private ExprCopyReplacer expr = new ExprCopyReplacer();
    private Map<Statement, Map<Variable, Variable>> defset;
    private int changes = 0;

    public CopyReplacer(Map<Statement, Map<Variable, Variable>> map) {
        this.defset = map;
    }

    public static int process(Statement statement, Map<Statement, Map<Variable, Variable>> map) {
        CopyReplacer copyReplacer = new CopyReplacer(map);
        AstTraverser<Map<Variable, Variable>> astTraverser = new AstTraverser<Map<Variable, Variable>>(copyReplacer);
        astTraverser.visit(statement, null);
        return copyReplacer.getChanges();
    }

    public final int getChanges() {
        return this.changes + this.expr.getChanges();
    }

    @Override
    public Statement visit(Statement statement, Map<Variable, Variable> map) {
        return super.visit(statement, this.defset.get(statement));
    }

    @Override
    protected Statement visitAssignmentStmt(AssignmentStmt assignmentStmt, Map<Variable, Variable> map) {
        assignmentStmt.setSource(this.visit(assignmentStmt.getSource(), map));
        if (assignmentStmt.getSource() instanceof VariableRefLinked && assignmentStmt.getDestination() instanceof VariableRefLinked) {
            VariableRefLinked variableRefLinked = (VariableRefLinked)assignmentStmt.getSource();
            VariableRefLinked variableRefLinked2 = (VariableRefLinked)assignmentStmt.getDestination();
            if (variableRefLinked.getReference() == variableRefLinked2.getReference()) {
                ++this.changes;
                return new NullStmt();
            }
        }
        return assignmentStmt;
    }

    @Override
    public Expression visit(Expression expression, Map<Variable, Variable> map) {
        assert (map != null);
        return this.expr.visit(expression, map);
    }

    @Override
    public Variable visit(Variable variable, Map<Variable, Variable> map) {
        assert (map != null);
        return this.expr.visit(variable, map);
    }
}

