/*
 * Decompiled with CFR 0.152.
 */
package disassembler.diStorm3;

import disassembler.diStorm3.OpcodeEnum;
import disassembler.diStorm3.Operand;
import java.io.PrintStream;
import util.NumPrint;

public class DecomposedInst {
    private long mAddr;
    private int mSize;
    private int mFlags;
    private int mSegment;
    private int mBase;
    private int mScale;
    private int mOpcode;
    public Operand[] mOperands;
    public DispVariant mDisp;
    public ImmVariant mImm;
    private int mUnusedPrefixesMask;
    private int mMeta;
    private int mRegistersMask;

    public long getAddress() {
        return this.mAddr;
    }

    public int getSize() {
        return this.mSize;
    }

    public OpcodeEnum getOpcode() {
        return OpcodeEnum.fromInt(this.mOpcode);
    }

    public int getSegment() {
        return this.mSegment & 0x7F;
    }

    public boolean isSegmentDefault() {
        return (this.mSegment & 0x80) == 128;
    }

    public int getBase() {
        return this.mBase;
    }

    public int getScale() {
        return this.mScale;
    }

    public int getUnusedPrefixesMask() {
        return this.mUnusedPrefixesMask;
    }

    public int getMeta() {
        return this.mMeta;
    }

    public int getRegistersMask() {
        return this.mRegistersMask;
    }

    public void dump(PrintStream printStream) {
        printStream.println((Object)this.getOpcode());
    }

    public String toString() {
        String string = NumPrint.toString(this.mAddr) + ":\t";
        string = string + this.getOpcode().toString();
        string = string + "\t";
        for (Operand operand : this.mOperands) {
            string = string + operand.getPretty(this);
            string = string + ", ";
        }
        return string;
    }

    public boolean isConstant() {
        for (Operand operand : this.mOperands) {
            switch (operand.getType()) {
                case Disp: 
                case Mem: 
                case None: 
                case Ptr: 
                case Reg: 
                case Smem: {
                    return false;
                }
            }
        }
        return true;
    }

    public long getConstantValue() {
        long l = this.mImm.mValue + this.mDisp.mDisplacement;
        block3: for (Operand operand : this.mOperands) {
            switch (operand.getType()) {
                case Pc: {
                    l += this.mAddr + (long)this.mSize;
                    continue block3;
                }
                default: {
                    throw new RuntimeException("Only addresses implemented: " + this);
                }
            }
        }
        return l;
    }

    public class DispVariant {
        private long mDisplacement;
        private int mSize;

        public long getDisplacement() {
            return this.mDisplacement;
        }

        public int getSize() {
            return this.mSize;
        }
    }

    public class ImmVariant {
        private long mValue;
        private int mSize;

        public long getImm() {
            return this.mValue;
        }

        public int getSize() {
            return this.mSize;
        }
    }
}

