/*
 * Decompiled with CFR 0.152.
 */
package disassembler.diStorm3;

import disassembler.diStorm3.DecomposedInst;
import disassembler.diStorm3.Registers;
import util.NumPrint;

public class Operand {
    private int mType;
    private int mIndex;
    private int mSize;

    public OperandType getType() {
        return OperandType.values()[this.mType];
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getSize() {
        return this.mSize;
    }

    private String signedHex(long l) {
        return NumPrint.toString(Math.abs(l));
    }

    private String ptrString(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 8: {
                return "BYTE PTR";
            }
            case 16: {
                return "WORD PTR";
            }
            case 32: {
                return "DWORD PTR";
            }
            case 64: {
                return "QWORD PTR";
            }
        }
        assert (false);
        return null;
    }

    public String getPretty(DecomposedInst decomposedInst) {
        switch (this.getType()) {
            case Reg: {
                return Registers.values()[this.mIndex].toString();
            }
            case Imm: {
                return NumPrint.toString(decomposedInst.mImm.getImm());
            }
            case Disp: {
                return this.ptrString(this.mSize) + " " + Registers.getDisplacementReg(this.mIndex).toString() + ":" + NumPrint.toString(decomposedInst.mDisp.getDisplacement());
            }
            case Smem: {
                String string = this.ptrString(this.mSize);
                string = string + " [";
                string = string + Registers.values()[this.mIndex].toString();
                string = string + this.signedHex(decomposedInst.mDisp.getDisplacement());
                string = string + "]";
                return string;
            }
            case Pc: {
                return NumPrint.toString(decomposedInst.mImm.getImm() + decomposedInst.getAddress() + (long)decomposedInst.getSize());
            }
            case Mem: {
                String string = " [";
                if (decomposedInst.getBase() < Registers.values().length) {
                    string = string + Registers.values()[decomposedInst.getBase()].toString();
                    string = string + "+";
                }
                string = string + Registers.values()[this.mIndex].toString();
                string = string + "*";
                string = string + Math.max(decomposedInst.getScale(), 1);
                string = string + this.signedHex(decomposedInst.mDisp.getDisplacement());
                string = string + "]";
                return string;
            }
        }
        assert (false);
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Operand)) {
            return false;
        }
        return ((Operand)object).mIndex == this.mIndex && ((Operand)object).mSize == this.mSize && ((Operand)object).mType == this.mType;
    }

    public static enum OperandType {
        None,
        Reg,
        Imm,
        Imm1,
        Imm2,
        Disp,
        Smem,
        Mem,
        Pc,
        Ptr;

    }
}

