/*
 * Decompiled with CFR 0.152.
 */
package elffile;

import elffile.ELFHeader;
import elffile.ELFStreamReader;
import elffile.ProgramHeader;
import elffile.SectionHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ELFFile {
    private ELFHeader header = null;
    private ProgramHeader[] programHeaders = null;
    private SectionHeader[] sectionHeaders = null;

    public static ELFFile loadFromStream(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        ELFStreamReader eLFStreamReader = new ELFStreamReader(randomAccessFile);
        ELFFile eLFFile = new ELFFile();
        eLFFile.header = ELFHeader.loadFromStream(eLFStreamReader);
        eLFStreamReader.seek(eLFFile.header.phoff);
        eLFFile.programHeaders = new ProgramHeader[eLFFile.header.phnum];
        for (n = 0; n < eLFFile.header.phnum; ++n) {
            eLFFile.programHeaders[n] = ProgramHeader.loadFromStream(eLFStreamReader);
        }
        eLFFile.sectionHeaders = new SectionHeader[eLFFile.header.shnum];
        eLFStreamReader.seek(eLFFile.header.shoff);
        for (n = 0; n < eLFFile.header.shnum; ++n) {
            eLFFile.sectionHeaders[n] = SectionHeader.loadFromStream(eLFStreamReader);
        }
        assert (eLFFile.header.getShtstrndx() >= 0 && eLFFile.header.getShtstrndx() < eLFFile.header.shnum);
        for (n = 0; n < eLFFile.header.shnum; ++n) {
            eLFFile.sectionHeaders[n].setName(eLFStreamReader.getName(eLFFile.sectionHeaders[n].getNameNr(), eLFFile));
        }
        return eLFFile;
    }

    public void dump() {
        this.header.dump();
        for (int i = 0; i < this.programHeaders.length; ++i) {
            this.programHeaders[i].dump();
        }
        for (SectionHeader sectionHeader : this.sectionHeaders) {
            sectionHeader.dump();
        }
    }

    public ProgramHeader[] getProgramHeaders() {
        return this.programHeaders;
    }

    public SectionHeader[] getSectionHeaders() {
        return this.sectionHeaders;
    }

    public SectionHeader getSection(String string) {
        for (SectionHeader sectionHeader : this.sectionHeaders) {
            if (!sectionHeader.getName().equals(string)) continue;
            return sectionHeader;
        }
        assert (false);
        return null;
    }

    public ELFHeader getHeader() {
        return this.header;
    }
}

