/*
 * Decompiled with CFR 0.152.
 */
package elffile;

import elffile.ELFStreamReader;
import java.io.IOException;
import util.NumPrint;

public class ELFHeader {
    public static final int NIDENT = 16;
    final byte[] ident = new byte[16];
    final short type;
    final short machine;
    final int version;
    final int entry;
    final int phoff;
    final int shoff;
    final int flags;
    final short ehsize;
    final short phentsize;
    final short phnum;
    final short shentsize;
    final short shnum;
    final short shtstrndx;
    static final int ET_NONE = 0;
    static final int ET_REL = 1;
    static final int ET_EXEC = 2;
    static final int ET_DYN = 3;
    static final int ET_CORE = 4;
    static final int ET_LOPROC = 65280;
    static final int ET_HIPROC = 255;
    static final String ET_NONE_msg = "No file type";
    static final String ET_REL_msg = "Relocatable file";
    static final String ET_EXEC_msg = "Executable file";
    static final String ET_DYN_msg = "Shared object file";
    static final String ET_CORE_msg = "Core file";
    static final String ET_LOPROC_msg = "Processor-specific";
    static final String ET_HIPROC_msg = "Processor-specific";
    static final int EM_NONE = 0;
    static final int EM_M32 = 1;
    static final int EM_SPARC = 2;
    static final int EM_386 = 3;
    static final int EM_68K = 4;
    static final int EM_88K = 5;
    static final int EM_860 = 7;
    static final int EM_MIPS = 8;
    static final int EM_MIPS_RS4_BE = 10;
    static final String EM_NONE_msg = "No machine";
    static final String EM_M32_msg = "AT&T WE 32100";
    static final String EM_SPARC_msg = "SPARC";
    static final String EM_386_msg = "Intel 80386";
    static final String EM_68K_msg = "Motorola 68000";
    static final String EM_88K_msg = "Motorola 68000";
    static final String EM_860_msg = "Intel 80860";
    static final String EM_MIPS_msg = "MIPS RS3000 Big-Endian";
    static final String EM_MIPS_RS4_BE_msg = "MIPS RS3000 Big-Endian";
    static final String EM_RESERVED_msg = "Reserved for future use";
    static final String[] EM = new String[]{"No machine", "AT&T WE 32100", "SPARC", "Intel 80386", "Motorola 68000", "Motorola 68000", "<unknown: 6>", "Intel 80860", "MIPS RS3000 Big-Endian", "<unknown: 9>", "MIPS RS3000 Big-Endian"};
    static final int EV_NONE = 0;
    static final int EV_CURRENT = 1;
    static final String EV_NONE_msg = "Invalid version";
    static final String EV_CURRENT_msg = "Current version";
    static final String[] EV = new String[]{"Invalid version", "Current version"};
    public static final int ELF_CLASS_NONE = 0;
    public static final int ELF_CLASS_32 = 1;
    public static final int ELF_CLASS_64 = 2;
    public static final String ELF_CLASS_NONE_msg = "Invalid class";
    public static final String ELF_CLASS_32_msg = "32-bit objects";
    public static final String ELF_CLASS_64_msg = "64-bit objects";
    public static final String[] ELF_CLASS = new String[]{"Invalid class", "32-bit objects", "64-bit objects"};
    public static final int ELF_DATA_NONE = 0;
    public static final int ELF_DATA_LSB = 1;
    public static final int ELF_DATA_MSB = 2;
    public static final String ELF_DATA_NONE_msg = "Invalid class";
    public static final String ELF_DATA_LSB_msg = "Little endian";
    public static final String ELF_DATA_MSB_msg = "Big endian";
    public static final String[] ELF_DATA = new String[]{"Invalid class", "Little endian", "Big endian"};

    private ELFHeader(byte[] byArray, short s, short s2, int n, int n2, int n3, int n4, int n5, short s3, short s4, short s5, short s6, short s7, short s8) {
        for (int i = 0; i < 16; ++i) {
            this.ident[i] = byArray[i];
        }
        this.type = s;
        this.machine = s2;
        this.version = n;
        this.entry = n2;
        this.phoff = n3;
        this.shoff = n4;
        this.flags = n5;
        this.ehsize = s3;
        this.phentsize = s4;
        this.phnum = s5;
        this.shentsize = s6;
        this.shnum = s7;
        this.shtstrndx = s8;
    }

    public static ELFHeader loadFromStream(ELFStreamReader eLFStreamReader) throws IOException {
        return new ELFHeader(eLFStreamReader.readUChar(16), eLFStreamReader.readE32Half(), eLFStreamReader.readE32Half(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Addr(), eLFStreamReader.readE32Off(), eLFStreamReader.readE32Off(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Half(), eLFStreamReader.readE32Half(), eLFStreamReader.readE32Half(), eLFStreamReader.readE32Half(), eLFStreamReader.readE32Half(), eLFStreamReader.readE32Half());
    }

    public char[] getELFMagic() {
        char[] cArray = new char[4];
        for (int i = 0; i < 4; ++i) {
            cArray[i] = (char)this.ident[i];
        }
        return cArray;
    }

    public byte getELFClass() {
        return this.ident[4];
    }

    public byte getELFDataEncoding() {
        return this.ident[5];
    }

    public byte getELFVersion() {
        return this.ident[6];
    }

    public void dump() {
        System.out.println("ELF magic         : " + String.valueOf(this.getELFMagic()));
        System.out.println("ELF class         : " + ELFHeader.getClassDesc(this.getELFClass()));
        System.out.println("ELF data encoding : " + ELFHeader.getDataEncodingDesc(this.getELFDataEncoding()));
        System.out.println("machine           : " + ELFHeader.getMachineDesc(this.machine));
        System.out.println("version           : " + this.getVersionDesc(this.version));
        System.out.println("entry point       : " + NumPrint.toString(this.entry));
        System.out.println("Program header");
        System.out.println("  - offset        : " + this.phoff);
        System.out.println("  - # entries     : " + this.phnum);
        System.out.println("  - entry size    : " + this.phentsize);
        System.out.println("Section header");
        System.out.println("  - offset        : " + this.shoff);
        System.out.println("  - # entries     : " + this.shnum);
        System.out.println("String table");
        System.out.println("  - offset        : " + this.shtstrndx);
        System.out.println("ELF header size   : " + this.ehsize);
        System.out.println();
    }

    private String getVersionDesc(int n) {
        return EV[n];
    }

    public static String getMachineDesc(short s) {
        if (EM.length < s) {
            return "<unknown: " + s + ">";
        }
        return EM[s];
    }

    public static String getDataEncodingDesc(byte by) {
        return ELF_DATA[by];
    }

    public static String getClassDesc(byte by) {
        return ELF_CLASS[by];
    }

    public short getShtstrndx() {
        return this.shtstrndx;
    }

    public int getEntry() {
        return this.entry;
    }
}

