/*
 * Decompiled with CFR 0.152.
 */
package elffile;

import elffile.ELFFile;
import elffile.SectionHeader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ELFStreamReader {
    private final RandomAccessFile ins;
    private int offset = 0;

    public ELFStreamReader(RandomAccessFile randomAccessFile) {
        this.ins = randomAccessFile;
    }

    public byte[] readUChar(int n) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = new Byte((byte)this.read());
        }
        return byArray;
    }

    public short readE32Half() throws IOException {
        short s = (short)(this.read() & 0xFF);
        short s2 = (short)(this.read() & 0xFF);
        return (short)(s2 << 8 | s);
    }

    public int readE32Word() throws IOException {
        int n = this.read() & 0xFF;
        int n2 = this.read() & 0xFF;
        int n3 = this.read() & 0xFF;
        int n4 = this.read() & 0xFF;
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    private int read() throws IOException {
        ++this.offset;
        return this.ins.read();
    }

    public int readE32Addr() throws IOException {
        return this.readE32Word();
    }

    public int readE32Off() throws IOException {
        return this.readE32Word();
    }

    public void seek(int n) throws IOException {
        this.ins.seek(n);
    }

    public int getOffset() {
        return this.offset;
    }

    public String readString(int n) {
        try {
            byte by;
            int n2 = this.offset;
            this.seek(n);
            String string = "";
            while ((by = this.readUChar(1)[0]) != 0) {
                string = string + (char)by;
            }
            this.offset = n2;
            this.seek(this.offset);
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getName(int n, ELFFile eLFFile) {
        assert (eLFFile.getHeader().getShtstrndx() >= 0);
        assert (eLFFile.getHeader().getShtstrndx() < eLFFile.getHeader().shnum);
        SectionHeader sectionHeader = eLFFile.getSectionHeaders()[eLFFile.getHeader().getShtstrndx()];
        assert (n >= 0);
        assert (n < sectionHeader.size());
        try {
            byte by;
            int n2 = this.offset;
            this.seek(sectionHeader.offset() + n);
            String string = "";
            while ((by = this.readUChar(1)[0]) != 0) {
                string = string + (char)by;
            }
            this.offset = n2;
            this.seek(this.offset);
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

