/*
 * Decompiled with CFR 0.152.
 */
package elffile;

import elffile.ELFStreamReader;
import java.io.IOException;
import util.NumPrint;

public class ProgramHeader {
    public final int type;
    public final int offset;
    public final int vaddr;
    public final int paddr;
    public final int filesz;
    public final int memsz;
    public final int flags;
    public final int align;
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_LOPROC = 0x70000000;
    public static final int PT_HIPROC = Integer.MAX_VALUE;
    public static final int PT_STACK = 1685382481;
    public static final String PT_NULL_msg = "Null";
    public static final String PT_LOAD_msg = "Loadable segment";
    public static final String PT_DYNAMIC_msg = "Dynamic linking information";
    public static final String PT_INTERP_msg = "Interpreter";
    public static final String PT_NOTE_msg = "Note section";
    public static final String PT_SHLIB_msg = "Shared library?";
    public static final String PT_PHDR_msg = "Program header";
    public static final String PT_LOPROC_msg = "LOPROC";
    public static final String PT_HIPROC_msg = "HIPROC";
    public static final String PT_STACK_msg = "Stack";
    public static final String[] PT = new String[]{"Null", "Loadable segment", "Dynamic linking information", "Interpreter", "Note section", "Shared library?", "Program header"};
    public static final int PF_X = 1;
    public static final int PF_W = 2;
    public static final int PF_R = 4;
    public static final int PF_MASKPROC = -268435456;
    public static final String PF_X_msg = "Execute";
    public static final String PF_W_msg = "Write";
    public static final String PF_R_msg = "Read";

    public ProgramHeader(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.type = n;
        this.offset = n2;
        this.vaddr = n3;
        this.paddr = n4;
        this.filesz = n5;
        this.memsz = n6;
        this.flags = n7;
        this.align = n8;
    }

    public static ProgramHeader loadFromStream(ELFStreamReader eLFStreamReader) throws IOException {
        return new ProgramHeader(eLFStreamReader.readE32Word(), eLFStreamReader.readE32Off(), eLFStreamReader.readE32Addr(), eLFStreamReader.readE32Addr(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word());
    }

    public static final String getFlagDesc(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = string + "Execute ";
        }
        if ((n & 2) != 0) {
            string = string + "Write ";
        }
        if ((n & 4) != 0) {
            string = string + "Read ";
        }
        return string;
    }

    public void dump() {
        System.out.println("type    : " + this.getTypeDesc(this.type));
        System.out.println("flags   : " + ProgramHeader.getFlagDesc(this.flags));
        System.out.println("vaddr   : " + NumPrint.toString(this.vaddr));
        System.out.println("paddr   : " + NumPrint.toString(this.paddr));
        System.out.println("offset  : " + NumPrint.toString(this.offset));
        System.out.println("filesz  : " + NumPrint.toString(this.filesz));
        System.out.println("memsz   : " + NumPrint.toString(this.memsz));
        System.out.println("align   : " + NumPrint.toString(this.align));
        System.out.println();
    }

    private String getTypeDesc(int n) {
        if (n < PT.length) {
            return PT[n];
        }
        if (n == Integer.MAX_VALUE) {
            return PT_HIPROC_msg;
        }
        if (n == 0x70000000) {
            return PT_LOPROC_msg;
        }
        if (n == 1685382481) {
            return PT_STACK_msg;
        }
        return "<unknown type : " + n + ">";
    }
}

