/*
 * Decompiled with CFR 0.152.
 */
package elffile;

import elffile.ELFStreamReader;
import java.io.IOException;
import util.NumPrint;

public class SectionHeader {
    public static final int SHT_NULL = 0;
    public static final int SHT_PROGBITS = 1;
    public static final int SHT_SYMTAB = 2;
    public static final int SHT_STRTAB = 3;
    public static final int SHT_RELA = 4;
    public static final int SHT_HASH = 5;
    public static final int SHT_DYNAMIC = 6;
    public static final int SHT_NOTE = 7;
    public static final int SHT_NOBITS = 8;
    public static final int SHT_REL = 9;
    public static final int SHT_SHLIB = 10;
    public static final int SHT_DYNSYM = 11;
    public static final int SHT_LOPROC = 0x70000000;
    public static final int SHT_HIPROC = Integer.MAX_VALUE;
    public static final int SHT_LOUSER = Integer.MIN_VALUE;
    public static final int SHT_HIUSER = -1;
    private String name = null;
    private int nameNr;
    private int type;
    private int flags;
    private int addr;
    private int offset;
    private int size;
    private int link;
    private int info;
    private int addralign;
    private int entsize;

    public SectionHeader(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.nameNr = n;
        this.type = n2;
        this.flags = n3;
        this.addr = n4;
        this.offset = n5;
        this.size = n6;
        this.link = n7;
        this.info = n8;
        this.addralign = n9;
        this.entsize = n10;
    }

    public static SectionHeader loadFromStream(ELFStreamReader eLFStreamReader) throws IOException {
        return new SectionHeader(eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word(), eLFStreamReader.readE32Word());
    }

    public void dump() {
        if (this.name == null) {
            System.out.println("name    : " + NumPrint.toString(this.nameNr));
        } else {
            System.out.println("name    : " + this.name);
        }
        System.out.println("type    : " + NumPrint.toString(this.type));
        System.out.println("flags   : " + NumPrint.toString(this.flags));
        System.out.println("addr    : " + NumPrint.toString(this.addr));
        System.out.println("offset  : " + NumPrint.toString(this.offset));
        System.out.println("size    : " + NumPrint.toString(this.size));
        System.out.println("link    : " + NumPrint.toString(this.link));
        System.out.println("info    : " + NumPrint.toString(this.info));
        System.out.println("align   : " + NumPrint.toString(this.addralign));
        System.out.println("entsize : " + NumPrint.toString(this.entsize));
        System.out.println();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getNameNr() {
        return this.nameNr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int size() {
        return this.size;
    }

    public int addr() {
        return this.addr;
    }

    public int offset() {
        return this.offset;
    }

    public boolean isInSection(long l) {
        return l >= (long)this.addr() && l < (long)(this.addr() + this.size());
    }

    public long toFileOffset(long l) {
        return l + (long)this.offset - (long)this.addr;
    }
}

